/*! phoscon-app 2025-11-11 */

import{serviceSend}from"./settings-gateway-machine.js";import{states,events}from"./settings-gateway-constants.js";const UPDATE_STATE_IDLE=0,UPDATE_STATE_SW=1,UPDATE_STATE_FW=2;app.updateState=UPDATE_STATE_IDLE;export function removeClassFromAll(elemList,classToRemove){if(elemList&&classToRemove)for(let elem of elemList)elem.classList.remove(classToRemove)};document.addEventListener("keyup",function(e){"Escape"===e.code&&serviceSend(events.ESC_PRESSED),"Enter"!==e.code&&"NumpadEnter"!==e.code||serviceSend(events.ENTER_PRESSED)});export function updateDateTime(){let utc=app.config.get("UTC")||"",date=(utc=utc.split("T"))[0].split("-"),time=utc[1].split(":");if(3!==date.length||3!==time.length)return;date[1]=parseInt(date[1])-1;let dt=new Date(Date.UTC(date[0],date[1],date[2],time[0],time[1],time[2])),lang=navigator.language||"de-DE";try{let region=new Intl.DateTimeFormat(lang).resolvedOptions(),timezone=app.config.get("timezone");timezone||(timezone="Europe/Berlin",app.config.save("timezone",timezone));let optionsDate={year:"numeric",month:"numeric",day:"numeric",timeZone:timezone},optionsTime={hour:"numeric",minute:"numeric",timeZone:timezone};return{date:date=new Intl.DateTimeFormat(region.locale,optionsDate).format(dt),time:time=new Intl.DateTimeFormat(region.locale,optionsTime).format(dt)}}catch(e){console.log(e)}};export function getNetworkId(){let nId=app.config.get("panid")||"unknown";if("unknown"!==nId){for(nId=nId.toString(16);nId.length%4;)nId="0"+nId;nId=nId.toUpperCase()}return nId};export function setViewBox(elem){if(!elem)return;let box=elem.getBBox(),x=Math.round(box.x)-2,y=Math.round(box.y)-2,width=Math.round(box.width)+4,height=Math.round(box.height)+4,parent=elem.parentNode;parent.setAttribute("viewBox",x+" "+y+" "+width+" "+height),parent.setAttribute("width",width),parent.setAttribute("height",height)};export function unloadListener(event){event.preventDefault(),event.returnValue=null};export function renameGw(name){app.config.save({name:name},{patch:!0})};export function setTimezone(tz){app.config.save({timezone:tz},{patch:!0})};export function changeNetworkDuration(duration){app.config.save({networkopenduration:duration},{patch:!0})};export function changeOtau(otauActive){app.config.save({otauactive:otauActive},{patch:!0})};export function changeDiscovery(discoveryActive){app.config.save({discovery:discoveryActive},{patch:!0})};export function changeZigbeeChannel(channel){app.config.save({zigbeechannel:channel},{patch:!0})};export function connectAppAllowed(){app.config.save({unlock:60},{patch:!0})};export function confirmOldPassword(oldPw){return new Promise((resolve,reject)=>{if(!oldPw)return reject(new TypeError("missing parameters"));const authHash=Base64.encode("delight:"+oldPw);var data={devicetype:"Phoscon"};"deCONZ"===app.config.get("modelid")&&(data.login="delight",data.devicetype+="#"+(app.standalone?"S":"B"),data.devicetype+=window.innerWidth+"x"+window.innerHeight),data=JSON.stringify(data);var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),"deCONZ"===app.config.get("modelid")&&xhr.setRequestHeader("Authorization","Basic "+authHash),xhr.onload=function(){if(4!==xhr.readyState||200!==xhr.status)return 403===xhr.status?reject(events.OLD_PW_FAIL):reject(events.GENERAL_FAIL);{const item=xhr.response.find(x=>x.success&&x.success.username);if(!item)return reject(new Error(`failed to login, status: ${jqXHR.status}`));deleteApikey(item.success.username).then(()=>resolve(events.OLD_PW_SUCCESS)).catch(err=>reject(err))}},xhr.onerror=function(){return reject(events.OLD_PW_FAIL)},xhr.send(data)})};function deleteApikey(apikey){return new Promise((resolve,reject)=>{if(!apikey)return reject(new TypeError("missing parameters"));var xhr=new XMLHttpRequest;xhr.open("DELETE","//"+app.session.gw+"/api/"+app.apikey+"/config/whitelist/"+apikey,!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(){4===xhr.readyState&&200===xhr.status?resolve():reject()},xhr.onerror=function(){reject()},xhr.send()})}export function sendChangePassword(oldPw,newPw){return new Promise((resolve,reject)=>{if(!newPw||!oldPw)return reject(new TypeError("missing parameters"));var oldpw=oldPw,newpw=newPw,params={username:"delight",oldhash:Base64.encode("delight:"+oldpw),newhash:Base64.encode("delight:"+newpw)};params=JSON.stringify(params);var xhr=new XMLHttpRequest;xhr.open("PUT","//"+app.session.gw+"/api/"+app.apikey+"/config/password",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(){4===xhr.readyState&&200===xhr.status?resolve(events.NEW_PW_SUCCESS):401===xhr.status?reject(events.NEW_PW_FAIL):reject(events.GENERAL_FAIL)},xhr.onerror=function(e){reject(events.NEW_PW_FAIL)},xhr.send(params)})};export function resetGw(){const params=JSON.stringify({resetGW:!0,deleteDB:!0});return new Promise(function(resolve,reject){localStorage.clear();var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/reset",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?resolve(serviceSend(events.RESET_SUCCESS)):reject(serviceSend(events.RESET_FAIL))},xhr.onerror=function(e){reject(serviceSend(events.RESET_FAIL))},xhr.send(params)})};export function resetHomebridge(){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("PUT","//"+app.session.gw+"/api/"+app.apikey+"/config/homebridge/reset",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?resolve(serviceSend(events.RESET_HOMEBRIDGE_SUCCESS)):reject(serviceSend(events.RESET_HOMEBRIDGE_FAIL))},xhr.onerror=function(e){reject(serviceSend(events.RESET_HOMEBRIDGE_FAIL))},xhr.send()})};export function restartOrShutdownGw(action){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/"+action,!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?resolve(serviceSend("restart"===action?events.RESTART_GW_SUCCESS:events.SHUTDOWN_GW_SUCCESS)):resolve(serviceSend("restart"===action?events.RESTART_GW_FAIL:events.SHUTDOWN_GW_FAIL))},xhr.onerror=function(e){resolve(serviceSend("restart"===action?events.RESTART_GW_FAIL:events.SHUTDOWN_GW_FAIL))},xhr.send()})};export function updateSoftware(){return app.updateTimerId&&(clearTimeout(app.updateTimerId),app.updateTimerId=void 0),new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/update",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?(app.updateState=UPDATE_STATE_SW,app.updateStartet=Date.now(),app.updateTimerId=setTimeout(pollUpdateReady,8e3)):resolve(serviceSend(events.UPDATE_FAIL))},xhr.onerror=function(e){resolve(serviceSend(events.UPDATE_FAIL))},xhr.send()})};export function updateFirmware(){return app.updateTimerId&&(clearTimeout(app.updateTimerId),app.updateTimerId=void 0),new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/updatefirmware",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?(app.updateState=UPDATE_STATE_FW,app.updateStartet=Date.now(),app.updateTimerId=setTimeout(pollUpdateReady,8e3)):resolve(serviceSend(events.UPDATE_FAIL))},xhr.onerror=function(e){resolve(serviceSend(events.UPDATE_FAIL))},xhr.send()})};export function pollUpdateReady(){if(Date.now()-app.updateStartet>6e5)return checkForUpdate(),void location.assign(location.pathname+"?"+createURLSearchHash()+Date.now());if(app.updateState===UPDATE_STATE_SW&&app.config.has("swupdate2")){let swUpdateState=app.config.get("swupdate2").state;"installing"!==swUpdateState&&"transferring"!==swUpdateState&&(app.updateState=UPDATE_STATE_IDLE)}else if(app.updateState===UPDATE_STATE_SW){let curVersion=app.config.get("swversion"),updateVersion=app.config.get("swupdate").version;-1!==compareVersionNumbers(curVersion,updateVersion)&&(app.updateState=UPDATE_STATE_IDLE,setTimeout(()=>{location.assign(location.pathname+"?"+createURLSearchHash()+Date.now())},5e3))}else if(app.updateState===UPDATE_STATE_FW)"idle"===app.config.get("fwupdatestate")&&(app.updateState=UPDATE_STATE_IDLE);else if(app.updateState===UPDATE_STATE_IDLE)return app.updateTimerId=void 0,void serviceSend(events.UPDATE_SUCCESS);app.updateTimerId=setTimeout(pollUpdateReady,5e3)};export function createBackup(){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/export",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?resolve(serviceSend(events.CREATE_BACKUP_SUCCESS)):resolve(serviceSend(events.CREATE_BACKUP_FAIL))},xhr.onerror=function(e){resolve(serviceSend(events.CREATE_BACKUP_FAIL))},xhr.send()})};export function loadBackup(data){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/fileupload",!0),xhr.responseType="json",xhr.setRequestHeader("Content-Type","multipart/form-data"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?(importConfig(),localStorage.clear()):resolve(serviceSend(events.LOAD_BACKUP_FAIL))},xhr.onerror=function(e){resolve(serviceSend(events.LOAD_BACKUP_FAIL))},xhr.send(data)})};function importConfig(){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","//"+app.session.gw+"/api/"+app.apikey+"/config/import",!0),xhr.responseType="json",xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",app.apiversion),xhr.onload=function(e){4===xhr.readyState&&200===xhr.status?resolve(serviceSend(events.LOAD_BACKUP_SUCCESS)):resolve(serviceSend(events.LOAD_BACKUP_FAIL))},xhr.onerror=function(e){resolve(serviceSend(events.LOAD_BACKUP_FAIL))},xhr.send()})}let tz=Intl.DateTimeFormat().resolvedOptions().timeZone;if(!tz){const lang=navigator.language||"en-GB";tz=lang.startsWith("de")?"Europe/Berlin":(lang.startsWith("en"),"Europe/London")}