/*! phoscon-app 2025-11-11 */

import{serviceSend}from"./settings-gateway-machine.js";import{states,events}from"./settings-gateway-constants.js";import{removeClassFromAll,updateDateTime,getNetworkId}from"./settings-gateway-functions.js";export const DateHandlerView=Backbone.View.extend({template:_.template(document.getElementById("date-area-view-template").innerHTML),el:"#dateArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.date=this.el.querySelector("#gatewayDate"),this.time=this.el.querySelector("#gatewayTime"),this.timezone=this.el.querySelector("#gatewayTimezone"),this.listenTo(app.config,"change:UTC",this.dateTime),this.listenTo(app.config,"change:timezone",this.dateTime),this.dateTime()},events:{"click button":function(){serviceSend(states.CHANGE_TIMEZONE)},"change #gatewayTimezoneSelect":"onTimezoneChange"},render:function(){const tzSelect=this.el.querySelector("#gatewayTimezoneSelect");return tzSelect&&app.config.get("timezone")&&(tzSelect.value=app.config.get("timezone")),this},dateTime:function(){let dt=updateDateTime();if(!dt)return this.date.textContent="",this.time.textContent="",void(this.timezone.textContent="");this.date.textContent=dt.date||"",this.time.textContent=dt.time||"",this.timezone.textContent=app.config.get("timezone")||""},onTimezoneChange:function(ev){const newTz=ev.currentTarget.value;newTz&&newTz!==app.config.get("timezone")&&(app.config.set("timezone",newTz),"function"==typeof app.config.save?app.config.save({timezone:newTz},{success:()=>{this.dateTime()}}):this.dateTime())}});export const LanguageHandlerView=Backbone.View.extend({template:_.template(document.getElementById("language-area-view-template").innerHTML),el:"#languageArea",initialize:function(){this.el.innerHTML=this.template(),this.selectField=this.el.querySelector("select"),this.render()},events:{"change select":function(ev){let el=ev.currentTarget;app.lang=el.value,localStorage.setItem("app.lang",app.lang),app.Devicetype.sendMessage("CHANGED_LANGUAGE",app.lang),getLangJSON(),loadLanguage(),localStorage.removeItem("savedChartData")}},render:function(){return app.lang&&(this.selectField.value=app.lang),this}});export const HomebridgeHandlerView=Backbone.View.extend({template:_.template(document.getElementById("homebridge-area-view-template").innerHTML),el:"#homebridgeArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.homebridgePin=this.el.querySelector("#homebridgePin"),this.homebridgeVersion=this.el.querySelector("#homebridgeVersion"),this.homebridgeUpdateVersion=this.el.querySelector("#homebridgeUpdateVersion"),this.autoUpdateBtnOn=this.el.querySelector("#autoUpdateOn"),this.autoUpdateBtnOff=this.el.querySelector("#autoUpdateOff"),this.buttonsField=this.el.querySelector("#homebridgeArea #div2"),this.homebridgeConfigBtn=this.el.querySelector("#openConfigUixBtn"),this.listenTo(app.config,"change:homebridgepin",this.setHomebridgePin),this.listenTo(app.config,"change:homebridgeversion",this.setHomebridgeVersion),this.listenTo(app.config,"change:homebridge",this.showHomebridgeArea),this.showHomebridgeArea(),this.setHomebridgePin(),this.setHomebridgeVersion()},events:{"click #resetHomebridgeBtn":function(){serviceSend(states.RESET_HOMEBRIDGE)}},showHomebridgeArea:function(){let homebridge=app.config.get("homebridge");if(app.config.has("homebridge")&&"not-managed"!==homebridge&&"not-available"!==homebridge){if(this.el.classList.remove("hidden"),"installing"===homebridge)this.homebridgePin.textContent=translate("txt_hb_installing"),this.buttonsField.classList.add("hidden");else if("install-error"===homebridge)this.homebridgePin.textContent=translate("txt_hb_install_error"),this.buttonsField.classList.add("hidden");else{let pin=app.config.get("homebridgepin"),version=app.config.get("homebridgeversion");if(!pin||!version)return;pin=pin.substr(0,3)+"-"+pin.substr(3,2)+"-"+pin.substr(5,3),this.homebridgePin.textContent=pin,this.homebridgeVersion.textContent=version,this.buttonsField.classList.remove("hidden")}app.config.get("swversion").split(".").join("")>21601?(this.homebridgeConfigBtn.setAttribute("href","http://"+app.session.gw+":8081"),this.homebridgeConfigBtn.setAttribute("target","_blank")):this.homebridgeConfigBtn.classList.add("hidden")}else this.el.classList.add("hidden")},setHomebridgePin:function(){let homebridge=app.config.get("homebridge"),version=app.config.get("homebridgeversion");if("installing"===homebridge||"install-error"===homebridge||!version)return;let pin=app.config.get("homebridgepin");pin&&(pin=pin.substr(0,3)+"-"+pin.substr(3,2)+"-"+pin.substr(5,3),this.homebridgePin.textContent=pin)},setHomebridgeVersion:function(){let version=app.config.get("homebridgeversion");version&&(this.homebridgeVersion.textContent=version)},render:function(){return this}});export const ConnectAppHandlerView=Backbone.View.extend({template:_.template(document.getElementById("connect-app-area-view-template").innerHTML),el:"#connectAppArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.authAllowedElem=this.el.querySelector("#authAllowed"),this.authAppBtn=this.el.querySelector("#connectAppArea button"),this.countdownTime=this.el.querySelector("#countdownTime")},events:{"click button":function(){serviceSend(states.ADVANCED_CONNECT)}},render:function(){return this},showAuthAllowed:function(){this.authAllowedElem.classList.add("show"),this.authAppBtn.classList.add("disabled"),this.countdownTime.textContent=""},hideAuthAllowed:function(){this.authAllowedElem.classList.remove("show"),this.authAppBtn.classList.remove("disabled"),this.countdownTime.textContent=""},countdown:function(seconds){this.countdownTime.textContent=seconds}});export const ChangeChannelHandlerView=Backbone.View.extend({template:_.template(document.getElementById("change-channel-area-view-template").innerHTML),el:"#changeChannelArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.networkId=this.el.querySelector("#networkId"),this.zigbeeChannel=this.el.querySelector("#zigbeeChannel"),this.listenTo(app.config,"change:panid",this.setNetworkId),this.listenTo(app.config,"change:zigbeechannel",this.setZigbeechannel),this.setNetworkId()},events:{"click button":function(){serviceSend(states.ADVANCED_CHANNEL)}},render:function(){return this},setNetworkId:function(){let nId=getNetworkId();nId&&(this.networkId.textContent=nId)},setZigbeechannel:function(){let channel=app.config.get("zigbeechannel");channel&&(this.zigbeeChannel.textContent=channel)}});export const LightDurationHandlerView=Backbone.View.extend({template:_.template(document.getElementById("light-duration-area-view-template").innerHTML),el:"#lightDurationArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.listenTo(app.config,"change:networkopenduration",this.render),this.render()},events:{"click .btn":"sendDur"},render:function(){let elemList=this.el.querySelectorAll("[data-dur]");0!==elemList.length&&removeClassFromAll(elemList,"btn-primary");let lightduration=app.config.get("networkopenduration");if(lightduration){let el=this.el.querySelector('[data-dur="'+lightduration+'"]');el&&el.classList.add("btn-primary")}return this},sendDur:function(ev){ev&&(ev=ev.currentTarget)&&(ev=ev.getAttribute("data-dur"),serviceSend({type:events.LIGHTDUR_PRESSED,activeDur:ev}))}});export const ChangeOtauHandlerView=Backbone.View.extend({template:_.template(document.getElementById("change-otau-area-view-template").innerHTML),el:"#otauArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.listenTo(app.config,"change:otauactive",this.render),this.render()},events:{"click #otauOnBtn":"activate","click #otauOffBtn":"deactivate"},render:function(){return app.config.get("otauactive")?(this.el.querySelector("#otauOnBtn").classList.add("btn-primary"),this.el.querySelector("#otauOffBtn").classList.remove("btn-primary")):(this.el.querySelector("#otauOffBtn").classList.add("btn-primary"),this.el.querySelector("#otauOnBtn").classList.remove("btn-primary")),this},activate:function(ev){serviceSend({type:events.CHANGE_OTAU_PRESSED,otau:!0})},deactivate:function(ev){serviceSend({type:events.CHANGE_OTAU_PRESSED,otau:!1})}});export const ChangeDiscoveryHandlerView=Backbone.View.extend({template:_.template(document.getElementById("change-discovery-area-view-template").innerHTML),el:"#discoveryArea",initialize:function(){this.el.innerHTML=this.template(app.config),this.listenTo(app.config,"change:discovery",this.render),this.render()},events:{"click #discoveryOnBtn":"activate","click #discoveryOffBtn":"deactivate"},render:function(){return app.config.get("discovery")?(this.el.querySelector("#discoveryOnBtn").classList.add("btn-primary"),this.el.querySelector("#discoveryOffBtn").classList.remove("btn-primary")):(this.el.querySelector("#discoveryOffBtn").classList.add("btn-primary"),this.el.querySelector("#discoveryOnBtn").classList.remove("btn-primary")),this},activate:function(ev){serviceSend({type:events.CHANGE_DISCOVERY_PRESSED,discovery:!0})},deactivate:function(ev){serviceSend({type:events.CHANGE_DISCOVERY_PRESSED,discovery:!1})}});