/*! phoscon-app 2025-11-11 */

export function initDetailsView(constants,injectSwitchWizzardSvg){let getSvgDevicePath=constants.getSvgDevicePath||null,getSvgIconPath=constants.getSvgIconPath||null,stateValues=[...constants.sensorValues,"battery","lowbattery"];return Backbone.View.extend({el:"#details",template:_.template(document.getElementById("sensor-details-template").innerHTML),initialize:function(model){this.model=model,app.session.snid=this.model.id,app.session.mac=this.model.get("mac"),this.sensors=app.sensors.where({mac:this.model.get("mac")}),this.sensors.forEach(s=>this.listenTo(s,"change",this.render)),void 0===this.model.attributes.swversion&&(this.model.attributes.swversion=0),this.el.innerHTML=this.template(this.model.attributes),this.nameLabel=this.el.querySelector("h1 span"),this.swVersion=this.el.querySelector(".version .data-val"),this.product=this.el.querySelector(".product.data-val");let iconImg=this.el.querySelector(".main-head > h1 > img"),iconPath=getSvgIconPath(this.model,"img/sensors/","svgPathsSensors"),detailPath=getSvgDevicePath(this.model,"img/sensors/","svgPathsSensors"),detailImg=this.el.querySelector("#detailImg");detailImg.setAttribute("src",detailPath),iconImg.setAttribute("src",iconPath),injectSwitchWizzardSvg([detailImg,iconImg]),loadLanguage(),this.render(),this.show()},render:function(){let version=this.model.get("swversion")||"unknown";this.swVersion.innerText=version;let product=this.model.get("product")||"unknown";this.product.innerText=product,this.nameLabel.textContent!==this.model.get("name")&&(this.nameLabel.textContent=this.model.get("name")),stateValues.forEach(value=>{let sensor=this.sensors.find(s=>value in s.get("config")||value in s.get("state")),el=this.el.querySelector("."+value);if(!sensor)return;let val=getValueState(value,sensor,constants);val&&(el.classList.remove("hide"),el.querySelector(".data-val").innerHTML=val)}),this.sensors.forEach(s=>{if(!("measured_value"in s.get("state")))return;let value=s.get("state").measured_value;var el,unit;switch("ug/m^3"===(unit=s.get("capabilities")&&s.get("capabilities").measured_value.unit||"")&&(unit="µg/m³"),s.get("type")){case"ZHAAirQuality":(el=this.el.querySelector(".airquality")).classList.remove("hide"),el.querySelector(".data-val").innerHTML=value+" "+unit;break;case"ZHAFormaldehyde":(el=this.el.querySelector(".formaldehyde")).classList.remove("hide"),el.querySelector(".data-val").innerHTML=value+" "+unit;break;case"ZHACarbonDioxide":(el=this.el.querySelector(".carbondioxide")).classList.remove("hide"),el.querySelector(".data-val").innerHTML=value+" ppm";break;case"ZHAParticulateMatter":(el=this.el.querySelector(".particularmatter")).classList.remove("hide"),el.querySelector(".data-val").innerHTML=value+" "+unit}});let s=this.sensors.find(s=>"reachable"in s.get("config"));if(s){let reachable=s.get("config").reachable,el=this.el.querySelector(".not-reachable");reachable?el.classList.add("hide"):el.classList.remove("hide")}if(s=this.sensors.find(s=>"lastupdated"in s.get("state"))){let lastu=s.get("state").lastupdated,el=this.el.querySelector(".lastupdated");if(lastu&&"none"!==lastu){let value=(lastu=moment.utc(lastu)).local().format("L LTS"),now=new Date,lastUpdated=new Date(lastu),seconds=new Date(now.getTime()-lastUpdated.getTime())/1e3,minutes=seconds/60,hours=minutes/60,days=hours/24;var text="",updateTimes=0;days>=1?(updateTimes=days,text=translate("text_before_days")):hours>=1?(updateTimes=hours,text=translate("text_before_hours")):minutes>=1?(updateTimes=minutes,text=translate("text_before_minutes")):(updateTimes=seconds,text=translate("text_before_seconds")),updateTimes=Math.floor(updateTimes),el.classList.remove("hide"),el.querySelector(".data-val").innerHTML=`<span>${value}</span><span><i>${text}</i></span>`,el.querySelector(".data-val .number").innerHTML=`${updateTimes}`}else el.classList.add("hide")}let imgs=this.el.querySelectorAll("img");if(injectSwitchWizzardSvg(imgs),"ZHAOpenClose"!==this.model.get("type"))return;const isOpen=this.model.get("state").open;let detailImg=this.el.querySelector("#detailImg");isOpen?detailImg.classList.add("is-open"):detailImg.classList.remove("is-open")},show:function(){this.el.classList.remove("hide")},hide:function(){this.sensors.forEach(s=>s.off("change")),this.el.classList.add("hide")}})};function getValueState(v,model,c){let value=model.get("config")[v]||model.get("state")[v];if(null!=value){switch(v){case"open":case"airquality":case"vibration":case"alarm":case"water":case"presence":case"fire":case"carbonmonoxide":value=getSvgOrTxt(value,v,c,model.get("state").airqualityppb);break;case"lightlevel":(value=Math.pow(10,value/1e4))>=1?value-=1:value=0,value=Math.round(value)+"&nbsp;Lux";break;case"temperature":value=parseInt(value/100)+"&nbsp;°C";break;case"humidity":case"moisture":value=parseFloat(value/100)+"&nbsp;%";break;case"battery":value+="&nbsp;%";break;case"pressure":value+="&nbsp;hPa";break;case"replacefilter":value=!0===value?translate("text_please_change"):translate("text_okay");break;case"speed":break;default:value=void 0}return value}}function getSvgOrTxt(value,val,{sensorValueIconPath:sensorValueIconPath},ppb){let path=sensorValueIconPath[val];if("airquality"==val){let trans=translate("txt_"+value);return ppb?`${ppb} ppb (${trans})`:trans}if("open"==val)return value?translate("text_isopen"):translate("text_closed");if(""==path)return value?translate("text_detected_true"):translate("text_detected");return`<img src="${path}" width="24" height="24" class="svg-icon svg-icon-detected${value?" detected":""}"/>`}