/*! phoscon-app 2025-11-11 */

import*as constants from"../main/main-constants.js";import{events}from"../settings-gateway/settings-gateway-constants.js";import{chartIntervalRemove}from"./dashboard-functions.js";export const DeviceItemView=Backbone.View.extend({tagName:"li",className:"deviceItemView",template:_.template($("#deviceItemViewTemplate").html()),initialize:function(data){this.isButtonClickDevice=!1,this.isDraggableDesktop=!1,this.isDraggableMobileDevice=!1,this.isDragging=!1,this.scrollInterval=null,this.service=data.service,this.name=this.model.get("name"),this.type="",this.hasExtraInformation=!1,this.parentRoomView=data.parentRoomView,this.deviceKey=null,this.draggedClone=null,this.isQuickDevice=data.isQuickDevice||!1,this.deviceListStyle=localStorage.getItem("quickDeviceList")||"normal",this.genericIcon=!1,this.disableDragging=!1,this.longPressActivated=!1,this.lastTouchLocation=[0,0],this.removeDeviceCheck=!1,this.el.id=this.model.id,this.deviceLink=`/${this.type}/${this.model.id}`,this.deviceValueValue=document.querySelector("#deviceValue"),this.roomList=document.querySelector("#roomList"),this.upDownIcon=document.querySelector(".temperature"),this.mel=document.querySelector("#mobileDeviceView"),this.fillOverlay=this.$(".fillOverlay"),this.quickBar=document.querySelector("#quickDeviceListView"),this.dashboardBtnContainer=document.querySelector("#dashboard-btn-container"),this.hoveredRoom=void 0,this.lastHoveredRoom=void 0,this.subSensors=app.getSubSensors(this.model),this.holdActive=!1,this.pressInterval=null,this.listenTo(this.model,"change",this.update),"FLS-PP3"===this.model.get("modelid")&&(this.flsWhite=getFlsPpWhite(this.model),this.listenTo(this.flsWhite,"change",this.update)),this.subSensors.forEach(sensor=>{this.listenTo(sensor,"change",this.update)}),this._setDeviceType(),this._handleShowValue(),this._setDraggable(),this._attachEventListeners(),this.render()},_setDeviceType:function(){this.quickBar.classList.remove("hideQuickbar");const attributes=this.model.attributes,name=this.model.get("name"),type=attributes.type||"";void 0!==attributes.hascolor?(this.type="lights",this.hasExtraInformation=type.includes("Smart plug")):attributes.uniqueid||name.includes("Daylight")?(this.type="sensors",this.hasExtraInformation=!0):(this.type="groups",this.hasExtraInformation=!1),"Window covering device"===type&&(this.type="blinds",this.hasExtraInformation=!0),"ZHAThermostat"===type&&(this.type="thermostats"),this.deviceLink=`/${this.type}/${this.model.id}`},_handleShowValue:function(){if(this.hasExtraInformation&&(this.model.get("uniqueid")||this.model.get("mac"))&&(this.deviceKey=this.model.get("uniqueid")?this.model.get("uniqueid").split("-")[0]:this.model.get("mac")),this.deviceKey){let itemConfig=JSON.parse(localStorage.getItem(this.deviceKey))||{};if(!itemConfig.showValue){let values=app.getSensorArrayInfo(this.model).filter(value=>!["macid","manufacture","product","updated"].includes(value.type));values.length>0?itemConfig.showValue=values[0].type:itemConfig.showValue=null}this.showValue=itemConfig.showValue,localStorage.setItem(this.deviceKey,JSON.stringify(itemConfig)),debouncedSaveLocalStorageToUserParameter()}else if("PHDL00"===this.model.get("modelid")&&this.name.includes("Daylight")){let values=app.getSensorArrayInfo(this.model).filter(value=>!["macid","manufacture","product","updated"].includes(value.type));values.length>0?this.showValue=values[0].type:this.showValue=null}},_setDraggable:function(){window.location.href.includes("groups")?(this.el.setAttribute("draggable","false"),this.draggable=!1):(this.roomList.classList.contains("disable-dragging")?(this.el.setAttribute("draggable","false"),this.el.style.pointerEvents="none",this.draggable=!1):(this.draggable=!0,this.el.setAttribute("draggable","true")),"groups"===this.type?this.el.setAttribute("draggable","false"):this.el.setAttribute("link",this.deviceLink))},_attachEventListeners:function(){this.isMobileDevice=/iPhone|iPad|iPod|Android/i.test(navigator.userAgent)||window.innerWidth<=1024,this.isTouchActive=!1;const attachMobileEvents=()=>{this.el.addEventListener("touchstart",this.touchStartHandler.bind(this),{passive:!1}),this.el.addEventListener("touchmove",this.eventDragMove.bind(this),{passive:!1}),this.el.addEventListener("touchend",this.eventTouchEnd.bind(this),{passive:!0}),this.el.addEventListener("touchcancel",this.eventClearDrag.bind(this),{passive:!0})},attachDesktopEvents=()=>{this.el.addEventListener("pointerdown",this.touchStartHandler.bind(this)),this.el.addEventListener("dragstart",this.eventDragStart.bind(this)),this.el.addEventListener("dragover",this.eventDragMove.bind(this)),this.el.addEventListener("dragend",this.eventDragEnd.bind(this))},detachEvents=()=>{this.el.removeEventListener("touchstart",this.touchStartHandler.bind(this)),this.el.removeEventListener("touchmove",this.eventDragMove.bind(this)),this.el.removeEventListener("touchend",this.eventTouchEnd.bind(this)),this.el.removeEventListener("touchcancel",this.eventClearDrag.bind(this)),this.el.removeEventListener("pointerdown",this.touchStartHandler.bind(this)),this.el.removeEventListener("dragstart",this.eventDragStart.bind(this)),this.el.removeEventListener("dragover",this.eventDragMove.bind(this)),this.el.removeEventListener("dragend",this.eventDragEnd.bind(this))};this.isMobileDevice?attachMobileEvents():attachDesktopEvents(),window.addEventListener("resize",()=>{const currentIsMobileDevice="ontouchstart"in window||navigator.maxTouchPoints>0;currentIsMobileDevice!==this.isMobileDevice&&(detachEvents(),this.isMobileDevice=currentIsMobileDevice,this.isMobileDevice?attachMobileEvents():attachDesktopEvents())})},events:{'pointerdown [data-btn-event="DASHBOARD_DEVICE_DELETE"]':"eventRemoveDevice",mouseup:"handlePointerUp"},update:function(updatedModel){if(updatedModel&&updatedModel.changed){const{config:config,state:state,action:action,name:name,lights:lights}=updatedModel.changed;(config||state||action||name||lights)&&this.render(!0)}},render:async function(updated){let el=void 0;if(void 0!==this.el&&null!==this.el?el=this.el:void 0!==this.$el[0]&&null!==this.$el[0]&&(el=this.$el[0]),!el)return;this.el=el,this.draggedClone&&this.draggedClone.remove();const deviceType=this._getDeviceType();el.innerHTML=this.template({deviceType:deviceType});const elements=this._getElements();if(this._updateDeviceIcon(elements.typeIcon),el.title=this.model.get("name"),this._setArrowVisibility(),this._updateReachability(),"small"==this.deviceListStyle&&el.classList.add("smallListStyle"),"LightGroup"===this.model.get("type")&&!0===updated){el.querySelector("#deviceItemIcon").classList.add("typeGroup"),!0===this.model.get("state").all_on?el.querySelector("#deviceItemIcon").innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#bulb-group-icon"></use>':!0===this.model.get("state").any_on?el.querySelector("#deviceItemIcon").innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#bulb-group-any-icon"></use>':(el.querySelector("#deviceItemIcon").classList.add("li-off"),el.querySelector("#deviceItemIcon").innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#bulb-group-icon"></use>');let groupCount=this.model.get("lights").length||0;this.model.attributes.lights.forEach(lid=>{let light=app.lights.get(lid);light&&"FLS-PP3 White"===light.get("modelid")&&(groupCount-=1)}),elements.groupCount.classList.remove("hidden"),elements.groupCount.innerHTML=groupCount}else await this._handleDeviceIcons(elements);this._setDeviceName(elements.nameField),el.classList.toggle("not-reachable",this._isNotReachable()),this._handleExtraInformation(elements);let deviceValueSettings=document.querySelector("#deviceValueSettings");if(!deviceValueSettings.classList.contains("hidden")){let deviceSettingsId=deviceValueSettings.querySelector("#deviceId").innerText;if(deviceSettingsId&&deviceSettingsId===this.model.id){const deviceValues=app.getSensorArrayInfo(this.model);let liCurrent=deviceValueSettings.querySelector('[data-device-type="current"]'),liPower=deviceValueSettings.querySelector('[data-device-type="power"]'),liVoltage=deviceValueSettings.querySelector('[data-device-type="voltage"]');if(void 0!==this.model.get("state").current&&null!==this.model.get("state").current&&liCurrent){let valueCurrent=deviceValues.find(device=>"current"===device.type);liCurrent.querySelector(".deviceValue").innerText=valueCurrent.value+" "+(valueCurrent.unit||"")}if(void 0!==this.model.get("state").power&&null!==this.model.get("state").power&&liPower){let valuePower=deviceValues.find(device=>"power"===device.type);liPower.querySelector(".deviceValue").innerText=valuePower.value+" "+(valuePower.unit||"")}if(void 0!==this.model.get("state").voltage&&null!==this.model.get("state").voltage&&liVoltage){let valueVoltage=deviceValues.find(device=>"voltage"===device.type);liVoltage.querySelector(".deviceValue").innerText=valueVoltage.value+" "+(valueVoltage.unit||"")}}}return this},_getDeviceType:function(){const type=this.model.get("type").toLowerCase();return"lightgroup"===type?"groups":type.includes("light")||type.includes("dimmable")?"lights":type.includes("window covering device")?"blinds":type.includes("thermostat")?"thermostats":type.includes("smart")?"smartplug":type.includes("on/off")||type.includes("plug")?"plug":type.includes("zha")&&this.model.get("config")?void 0===this.model.get("config").heatsetpoint?"sensors":"thermostats":"smartplug"===type?"smartplug":"sensors"},_getElements:function(){return{typeIcon:this.el?this.el.querySelector("#deviceItemIcon"):null,deviceValueValue:this.el?this.el.querySelector("#deviceValueValue"):null,groupCount:this.el?this.el.querySelector(".deviceGroupCount"):null,nameField:this.el?this.el.querySelector("#deviceNameField"):null,deviceRightArrow:this.el?this.el.querySelector("#deviceValueArrowRight"):null,deviceLeftArrow:this.el?this.el.querySelector("#deviceValueArrowLeft"):null,deviceValueField:this.el?this.el.querySelector(".deviceValueSelect"):null,deviceValueLabel:this.el?this.el.querySelector("#deviceValueLabel"):null,upDownIConTemp:this.el?this.el.querySelector(".temperature"):null,showBattery:this.el?this.el.querySelector(".battery"):null,roomListItem:this.el?this.el.querySelector("#roomDeviceItemList"):null,deviceItemNew:this.el?this.el.querySelector(".deviceItemView "):null}},quickUpdateBulbIcon:function(on){this.el&&(on?this.el.querySelector("#deviceItemIcon").classList.remove("li-off"):this.el.querySelector("#deviceItemIcon").classList.contains("li-off")||this.el.querySelector("#deviceItemIcon").classList.add("li-off"))},quickUpdateRoomOnOffIcon:function(on,view){let element=view.el||view.$el[0];if(element&&!element.classList.contains("quickDevice")&&!document.location.hash.includes("groups")){var anyOn=!1;view.parentRoomView.roomDeviceItemViews.forEach(deviceItem=>{"lights"===deviceItem.type&&(deviceItem.el.querySelector("#deviceItemIcon").classList.contains("li-off")||deviceItem.el.classList.contains("li-off")||(anyOn=!0))}),on?view.parentRoomView.el.querySelector("#btn-group-control").classList.remove("li-off"):anyOn||view.parentRoomView.el.querySelector("#btn-group-control").classList.contains("li-off")||view.parentRoomView.el.querySelector("#btn-group-control").classList.add("li-off")}},quickUpdateBulbIconsForGroup:function(on,view,group){let lightsColorOn=localStorage.getItem("showColourLights");view.parentRoomView.roomDeviceItemViews.forEach(deviceItem=>{if("lights"===deviceItem.type&&group.get("lights").includes(deviceItem.model.get("id"))){let itemIcon=deviceItem.el.querySelector("#deviceItemIcon");if(null!=itemIcon)if(on){if(itemIcon.classList.remove("li-off"),"true"==lightsColorOn)this.model.attributes.action}else itemIcon.classList.contains("li-off")||itemIcon.classList.add("li-off")}})},_updateDeviceIcon:function(typeIconElement){let lightsColorOn=localStorage.getItem("showColourLights");if("LightGroup"===this.model.get("type")){if(void 0!==this.model.get("state"))if(!0===this.model.get("state").any_on||!0===this.model.get("state").all_on){if(typeIconElement.classList.remove("li-off"),"true"==lightsColorOn){const state=this.model.attributes.action;setLightColour(state,typeIconElement)}}else typeIconElement.classList.contains("li-off")||typeIconElement.classList.add("li-off")}else if(void 0!==this.model.get("state").on)if(!0===this.model.get("state").on){if("FLS-PP3"===this.model.get("modelid")){let white=getFlsPpWhite(this.model);white?!0===this.model.get("state").on&&!0===white.get("state").on&&typeIconElement.classList.remove("li-off"):typeIconElement.classList.remove("li-off")}else typeIconElement.classList.remove("li-off");if("true"==lightsColorOn){const state=this.model.attributes.state;setLightColour(state,typeIconElement),app.groups.filter(g=>g.get("lights").includes(this.model.get("id"))).forEach(g=>{let deviceItem=document.getElementById(g.get("id"));deviceItem&&deviceItem.title&&deviceItem.title.startsWith("Group")&&setLightColour(state,deviceItem.querySelector("#deviceItemIcon"))})}}else if("FLS-PP3"===this.model.get("modelid")){let white=getFlsPpWhite(this.model);white?!1===this.model.get("state").on&&!1===white.get("state").on&&(typeIconElement.classList.contains("li-off")||typeIconElement.classList.add("li-off")):typeIconElement.classList.contains("li-off")||typeIconElement.classList.add("li-off")}else null==typeIconElement||typeIconElement.classList.contains("li-off")||typeIconElement.classList.add("li-off");else"Range extender"===this.model.get("type")&&(typeIconElement.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#generic-sensor-icon"></use>')},_setArrowVisibility:function(){const opacity="true"===localStorage.selectDeviceArrows?1:0;this.$("#deviceValueArrowLeft").css("opacity",opacity),this.$("#deviceValueArrowRight").css("opacity",opacity)},_updateReachability:function(){let reachable=!1;this.model.get("type")&&(this.model.get("type").includes("Group")||this.model.get("type").includes("Daylight"))&&(reachable=!0),this.model.get("state")&&this.model.get("state").reachable&&(reachable=!0),this.model.get("config")&&this.model.get("config").reachable&&(reachable=!0),reachable?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable")},_handleDeviceIcons:async function(elements){const setIcon=iconId=>elements.typeIcon.innerHTML=`<use id="${this.el.id}" transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="${iconId}"></use>`,type=this.type;if("lights"===type){this.model.attributes.type.includes("plug")&&!this.model.attributes.type.includes("dimmable")&&setIcon("#socket-icon");let waterValveIcon=waterValves[this.model.get("manufacturername")];void 0!=waterValveIcon&&setIcon(waterValveIcon.icon),elements.typeIcon.classList.add("deviceClickable")}else if("blinds"===type)setIcon("#generic-blind-icon"),elements.typeIcon.classList.add("deviceClickable");else if("thermostats"===type)setIcon("#thermostat-icon"),elements.typeIcon.classList.add("deviceClickable");else if("groups"===type){const groupNumber=this.deviceLink.match(/\/(\d+)$/)[1],groupType=await checkGrouptype(groupNumber);setIcon({lights:"#bulb-group-icon",blinds:"#blind-group",thermostats:"#thermostat-group"}[groupType]||"unknown-group-type");const group=app.groups.get(groupNumber);let groupCount=0;group&&groupType&&group.get(groupType)&&(groupCount=group.get(groupType).length),this.model.attributes.lights.forEach(lid=>{let light=app.lights.get(lid);light&&"FLS-PP3 White"===light.get("modelid")&&(groupCount-=1)}),elements.groupCount.classList.remove("hidden"),elements.groupCount.innerHTML=groupCount,elements.typeIcon.classList="typeGroup li-off",!0===this.model.get("state").all_on?(elements.typeIcon.classList="typeGroup",elements.typeIcon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#bulb-group-icon"></use>'):!0===this.model.get("state").any_on&&(elements.typeIcon.classList="typeGroup",elements.typeIcon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#bulb-group-any-icon"></use>')}else if("sensors"===type){let sensorIcon,sensorFromMap,sensorIconSetting=localStorage.getItem("sensorIconSetting");if(sensorIconSetting||(sensorIconSetting="vendor"),this.model.get("manufacturername")&&this.model.get("modelid")&&(sensorFromMap=deviceInfoMap[this.model.get("manufacturername")])&&(sensorFromMap="type"===sensorIconSetting&&"Daylight"!==this.model.get("type")?void 0:sensorFromMap.find(s=>s.modelid.includes(this.model.get("modelid"))||this.model.get("modelid").includes(s.modelid)))&&(sensorIcon=sensorFromMap.icon),!sensorIcon&&this.model.get("type")||"#generic-sensor-icon"===sensorIcon&&"vendor"===sensorIconSetting){const subSensors=app.getSubSensors(this.model);(sensorIcon=this.selectSensorIconType(subSensors))&&setIcon(sensorIcon)}setIcon(sensorIcon&&"generic"!==sensorIconSetting?sensorIcon:"#generic-sensor-icon")}},selectSensorIconType:function(sensorList){let types=sensorList.map(s=>s.get("type"));return types.includes("ZHAPresence")?constants.sensorTypeIcons.ZHAPresence:types.includes("ZHALightLevel")?constants.sensorTypeIcons.ZHALightLevel:types.includes("ZHAOpenClose")?constants.sensorTypeIcons.ZHAOpenClose:types.includes("ZHAVibration")?constants.sensorTypeIcons.ZHAVibration:types.includes("ZHAAirQuality")||types.includes("ZHACarbonMonoxid")||types.includes("ZHAParticulateMatter")||types.includes("ZHAFormaldehyde")||types.includes("ZHACarbonDioxide")?constants.sensorTypeIcons.ZHAAirQuality:types.includes("ZHAWater")?constants.sensorTypeIcons.ZHAWater:types.includes("ZHAFire")?constants.sensorTypeIcons.ZHAFire:types.includes("ZHAAlarm")?constants.sensorTypeIcons.ZHAAlarm:types.includes("ZHATemperature")?constants.sensorTypeIcons.ZHATemperature:types.includes("ZHAThermostat")?constants.sensorTypeIcons.ZHAThermostat:types.includes("ZHAHumidity")||types.includes("ZHAMoisture")?constants.sensorTypeIcons.ZHAHumidity:types.includes("ZHAPressure")?constants.sensorTypeIcons.ZHAPressure:void 0},_setDeviceName:function(nameFieldElement){if(nameFieldElement&&(nameFieldElement.textContent=this.model.get("name"),"Daylight"===this.model.attributes.type)){const removeLightTrigger=document.getElementById("deviceHead");removeLightTrigger&&removeLightTrigger.removeAttribute("data-btn-event")}},_isNotReachable:function(){let reachable=!1;return this.model.get("type")&&(this.model.get("type").includes("Group")||this.model.get("type").includes("Daylight"))&&(reachable=!0),this.model.get("state")&&this.model.get("state").reachable&&(reachable=!0),this.model.get("config")&&this.model.get("config").reachable&&(reachable=!0),!reachable},_handleExtraInformation:function(elements){if(this.isQuickDevice)this.el.classList.add("quickDevice"),"sensors"==this.type&&this.el.classList.add("sensor"),this.el.classList.add("quickDevice");else if(this.hasExtraInformation){elements.nameField.classList.add("extraInfo"),elements.deviceValueField.classList.remove("hidden"),elements.deviceValueLabel.innerHTML="",elements.deviceValueValue.innerHTML="",app.getSensorArrayInfo(this.model).forEach(value=>{value.type===this.showValue&&(elements.deviceValueLabel.innerHTML=`${value.label}:`,elements.deviceValueValue.innerHTML="Wh"===value.unit&&value.value>1e4?`${Math.floor(value.value/1e3)} kWh`:"mA"===value.unit&&value.value>1e4?`${Math.floor(value.value/1e3)} A`:`${value.value} ${value.unit}`),"Battery"===value.label&&value.value<6&&elements.showBattery.classList.remove("hidden")})}},eventClearDrag:function(){document.querySelectorAll(".dragging").forEach(clone=>{clone.style.display="none",clone.remove()}),this.draggedClone&&(this.draggedClone.style.display="none",this.draggedClone.remove())},checkRemoveFavFromRoom(event){const deviceId=event.currentTarget.id;let existingData=localStorage.getItem("savedFavSensorData"),dataArray=existingData?JSON.parse(existingData):[];dataArray=(deviceId=>dataArray.filter(data=>data.sensorId!==deviceId))(deviceId),localStorage.setItem("savedFavSensorData",JSON.stringify(dataArray));let existingDataStored=localStorage.getItem("savedChartData"),dataArrayStored=[];try{dataArrayStored=existingDataStored?JSON.parse(existingDataStored):[]}catch(error){console.error("Error parsing data from localStorage:",error),dataArrayStored=[]}const matchedItem=dataArrayStored.find(item=>item.sensorId===deviceId),roomId=matchedItem?matchedItem.roomId:null;if(roomId){dataArrayStored=dataArrayStored.filter(item=>item.sensorId!==deviceId);try{localStorage.setItem("savedChartData",JSON.stringify(dataArrayStored))}catch(error){console.error("Error saving data to localStorage:",error)}chartIntervalRemove(roomId)}else console.log("No matching roomId found for the given sensorId");debouncedSaveLocalStorageToUserParameter()},getDeviceScrollFactor(){const screenWidth=window.innerWidth,factor=.5*window.devicePixelRatio;return screenWidth<768?1250*factor:screenWidth>=768?2.5*factor:3*factor},touchStartHandler:function(event){this.isScrolling=!1;const isTouchEvent=event.type.startsWith("touch"),isMouseEvent="pointerdown"===event.type;this.isDragging=null,this.longPressThresholdDrag=100,this.longPressThreshold=500,clearTimeout(this.buttonActionTimer);const startTime=Date.now();if(isTouchEvent){this.isDragging=!1,this.mobile=!0,app.roomViews.isDraggingDevice=!1;event.touches[0].clientY;const startTime=Date.now(),handleLongPress=()=>{if(!this.isDragging&&!this.isButtonClickDevice&&!this.isScrolling){let type=this.model.attributes.type;switch((type.includes("light")||type.includes("LightGroup")||type.includes("dimmable"))&&(type="lights"),type.includes("plug")&&(type="plugs"),type){case"ZHAThermostat":this.eventDeviceChange();break;case"Window covering device":this.eventBlindsChange();break;case"lights":this.eventLightChange(event),this.render()}}clearTimeout(this.buttonActionTimer)};this.buttonActionTimer=setTimeout(handleLongPress,this.longPressThreshold);const touchMoveHandler=moveEvent=>{if(this.isScrolling=!this.isDragging,this.isDragging){this.stopListening(this.model,"change"),moveEvent.preventDefault();const currentY=moveEvent.touches[0].clientY,container=document.querySelector("#mainContainer");container&&currentY<300?this.scrollInterval||(this.scrollInterval=setInterval(()=>{container.scrollBy(0,-5)},16)):container&&currentY>window.innerHeight-200?this.scrollInterval||(this.scrollInterval=setInterval(()=>{container.scrollBy(0,5)},16)):(clearInterval(this.scrollInterval),this.scrollInterval=null),document.querySelector(".removeDeviceArea").classList.contains("drag-over")&&(clearInterval(this.scrollInterval),this.scrollInterval=null)}},touchEndHandler=event=>{if(Date.now()-startTime<=500&&!this.isDragging){if("deviceNameField"===event.target.id||"deviceValueLabel"===event.target.id||"deviceValueValue"===event.target.id||"deviceGroupCount"===event.target.className||"deviceInfo"===event.target.id)return clearInterval(this.pressInterval),this.pressInterval=null,void(this.isScrolling||this.eventDeviceSettings());if("ZHAThermostat"===this.model.attributes.type&&(clearInterval(this.pressInterval),this.pressInterval=null,this.isScrolling||this.eventDeviceChange()),"Window covering device"===this.model.attributes.type&&(clearInterval(this.pressInterval),this.pressInterval=null,this.isScrolling||this.eventBlindsChange()),this.type.includes("light")||this.type.includes("plug")){if(!this.isScrolling)if(this.service.send({type:constants.events.DASHBOARD_TOGGLE_DEVICE,view:this}),this.model.attributes.state.on){let deviceIcon=this.$el[0].querySelector("#deviceItemIcon");if("FLS-PP3"==this.model.get("modelid")){let l=getFlsPpWhite(this.model);l&&!1===l.get("state").on&&(deviceIcon.classList.contains("li-off")||deviceIcon.classList.add("li-off"))}else deviceIcon.classList.contains("li-off")||deviceIcon.classList.add("li-off")}else{this.$el[0].querySelector("#deviceItemIcon").classList.remove("li-off")}}else if("groups"===this.type&&!this.isScrolling){if(!document.querySelector("#sliderWrapper").classList.contains("hidden"))return;clearInterval(this.pressInterval),this.pressInterval=null,this.service.send({type:constants.events.DASHBOARD_TOGGLE_GROUP,view:this})}}clearTimeout(this.buttonActionTimer),clearInterval(this.scrollInterval),this.scrollInterval=null,document.removeEventListener("touchcancel",touchEndHandler),document.removeEventListener("touchmove",touchMoveHandler),document.removeEventListener("touchstart",touchMoveHandler),document.removeEventListener("touchend",touchMoveHandler)};document.addEventListener("touchmove",touchMoveHandler,{passive:!1}),document.addEventListener("touchend",touchEndHandler),document.addEventListener("touchcancel",touchEndHandler),document.addEventListener("touchstart",e=>this.eventDragStart(e))}if(isMouseEvent){if(["blindGroup","ThermostatGroup"].includes(this.model.attributes.type))return void event.preventDefault();const checkPressDuration=()=>{const currentDuration=Date.now()-startTime;if(!this.isButtonClickDevice){if(currentDuration>=500&&!this.isDragging){if(this.model.attributes.type.includes("plug")&&!this.model.attributes.type.includes("dimmable"))return clearInterval(this.pressInterval),void(this.pressInterval=null);this.model.attributes.type.includes("Window")&&(this.eventBlindsChange(),clearInterval(this.pressInterval),this.pressInterval=null),this.model.attributes.type.includes("ZHAThermostat")&&(this.eventDeviceChange(),clearInterval(this.pressInterval),this.pressInterval=null),this.model.attributes.type.includes("light")&&(this.eventLightChange(),clearInterval(this.pressInterval),this.pressInterval=null),this.model.attributes.type.includes("LightGroup")&&(this.eventLightChange(),clearInterval(this.pressInterval),this.pressInterval=null)}this.isDragging&&(clearInterval(this.pressInterval),this.pressInterval=null)}};null!==this.pressInterval&&(clearInterval(this.pressInterval),this.pressInterval=null),this.pressInterval=setInterval(checkPressDuration,50)}},handlePointerUp:function(event){if(!this.isDragging){if("deviceNameField"===event.target.id||"deviceValueLabel"===event.target.id||"deviceValueValue"===event.target.id||"deviceGroupCount"===event.target.className||"deviceInfo"===event.target.id||this.deviceLink.includes("/sensors/"))return this.eventDeviceSettings(),clearInterval(this.pressInterval),void(this.pressInterval=null);if("ZHAThermostat"===this.model.attributes.type)return clearInterval(this.pressInterval),this.pressInterval=null,void this.eventDeviceChange();if("Window covering device"===this.model.attributes.type)return clearInterval(this.pressInterval),this.pressInterval=null,void this.eventBlindsChange();if(this.type.includes("light")||this.type.includes("plug")){if(clearInterval(this.pressInterval),this.pressInterval=null,!1===this.model.get("state").reachable)return;if(!document.querySelector("#sliderWrapper").classList.contains("hidden"))return;this.service.send({type:constants.events.DASHBOARD_TOGGLE_DEVICE,view:this})}if("groups"===this.type){if(clearInterval(this.pressInterval),this.pressInterval=null,!document.querySelector("#sliderWrapper").classList.contains("hidden"))return;this.service.send({type:constants.events.DASHBOARD_TOGGLE_GROUP,view:this})}}clearInterval(this.pressInterval),this.pressInterval=null},eventLightChange:function(event){if(!1!==this.model.get("state").reachable&&!1===this.isScrolling){let deviceValueSettings=document.querySelector("#deviceValueSettings");if("Daylight"===this.model.attributes.type||!deviceValueSettings.classList.contains("hidden"))return;if(this.model.attributes.type.includes("light")||this.model.attributes.type.includes("dimmable")||this.model.attributes.type.includes("LightGroup")){return app.lightSliderViews.selectLight(this.model),document.getElementById("deviceValueSettingsOuter").classList.remove("hidden"),void(this.isButtonClickDevice=!1)}}},eventDeviceSettings:function(event){if(!document.getElementById("sliderWrapper").classList.contains("hidden"))return;let deviceValueSettings=document.getElementById("deviceValueSettings"),outer=document.getElementById("deviceValueSettingsOuter");if(deviceValueSettings.classList.contains("hidden"))app.deviceValuesListView.showDeviceValues(this.model),outer.classList.remove("hidden"),app.closeDeviceSettingsTimer=new Date,this.isButtonClickDevice=!1;else{let now=new Date;if(app.closeDeviceSettingsTimer){let elapsed=now-app.closeDeviceSettingsTimer;if(console.log("elapsed: "+elapsed),elapsed<500)return void(this.isButtonClickDevice=!1)}deviceValueSettings.classList.add("hidden")}},eventDeviceChange:function(){let wrapperThermostat=document.getElementById("wrapperThermostat"),outer=document.getElementById("deviceValueSettingsOuter");this.isButtonClickDevice=!0,app.thermostatChangeViews.selectThermostat(this.model),wrapperThermostat&&outer&&(outer.classList.contains("hidden")?(outer.classList.remove("hidden"),app.closeDeviceSettingsTimer=new Date):(wrapperThermostat.classList.add("hidden"),outer.classList.add("hidden")))},eventBlindsChange:function(){if(!document.querySelector("#deviceValueSettings").classList.contains("hidden"))return;let sliderWrapperBlinds=document.getElementById("sliderWrapperBlinds"),outer=document.getElementById("deviceValueSettingsOuter");this.isButtonClickDevice=!0,sliderWrapperBlinds.classList.contains("hidden")?(app.blindSliderViews.selectBlind(this.model),outer.classList.remove("hidden"),this.isButtonClickDevice=!1):sliderWrapperBlinds.classList.add("hidden"),this.render()},checkValueSelection:function(index,values){return index>values.length-1?0:index<0?values.length-1:index},loadCheckboxState:function(checkboxName,checkbox){const savedState=localStorage.getItem(checkboxName);null!==savedState&&(checkbox.checked="true"===savedState,checkbox.dispatchEvent(new Event("change")))},handleEventPropagation:function(event){event.preventDefault(),event.stopPropagation()},preventDefaultHandler(event){this.isDragging&&event.preventDefault()},isIntersecting:function(rect1,rect2){return rect1.left<rect2.right&&rect1.right>rect2.left&&rect1.top<rect2.bottom&&rect1.bottom>rect2.top},quickBarMobilecheckRightEdge:function(touchLocation){touchLocation.clientX>=300?this.quickBar.classList.remove("hideQuickbar"):this.quickBar.classList.add("hideQuickbar")},eventDragStart:function(event){if(!window.location.href.includes("groups")&&this.$el[0].draggable&&"groups"!==this.type&&this.$el){if(event.currentTarget&&!this.isMobileDevice&&event.currentTarget.draggable&&(this.isDragging=!0),this.isMobileDevice&&this.$el){this.draggedClone=this.$el[0].cloneNode(!0),this.draggedClone.classList.add("dragged");const touchLocation=event.targetTouches[0];this.updateDraggedClonePosition(touchLocation)}this.parentRoomView&&(this.parentRoomView.isButtonClickRooms=!0),(this.isButtonClickDevice||"groups"===this.type)&&this.removeHightlightsAndClones()}},eventDragMove:function(event){if(window.location.href.includes("groups"))return;let scrollPosition=document.getElementById("mainContainer").scrollTop;localStorage.setItem("scrollPosition",scrollPosition);const roomListView=document.getElementById("roomList");if(roomListView){roomListView.querySelectorAll(".roomItemView").forEach(element=>{let resourcelink=app.resourcelinks.get(element.dataset.resourceid);if(resourcelink&&resourcelink.attributes&&Array.isArray(resourcelink.attributes.links)){resourcelink.attributes.links.includes(this.deviceLink)&&this.isDragging&&(element.classList.add("alreadyInRoom"),this.RoomIdCurrent=element.dataset.roomid,this.alreadyInRoom=element.classList)}else console.warn(`No valid resource link found for resourceId: ${element.dataset.resourceid}`)})}if(!this.$el[0].draggable||"groups"===this.type)return;this.isDragging=!0,this.createArrow(event),this.parentRoomView&&(this.RoomIdCurrent=this.parentRoomView.roomid,this.GroupIdCurrent=this.parentRoomView.groupId),app.roomViews.isDraggingDevice=!0,this.draggedClone&&document.body.appendChild(this.draggedClone);const removeDeviceArea=document.querySelector(".removeDeviceArea");if(!event.currentTarget.classList.contains("quickDevice")&&removeDeviceArea&&(removeDeviceArea.classList.remove("hidden"),!this.mobile&&null!==arrow))for(let i=0;i<arrow.length;i++)arrow[i].remove();let touchLocation;if((touchLocation=!!event.type.startsWith("touch")&&event.targetTouches[0])&&(this.lastTouchLocation=[touchLocation.pageX,touchLocation.pageY],this.quickBarMobilecheckRightEdge(touchLocation),this.draggedClone)){let offset=75;"small"===this.deviceListStyle&&this.draggedClone.offsetWidth&&this.draggedClone.offsetHeight&&(offset=Math.min(this.draggedClone.offsetWidth,this.draggedClone.offsetHeight)/2),this.draggedClone.style.transform=`translate(${touchLocation.pageX-offset}px, ${touchLocation.pageY-offset}px)`;const rectClone=this.draggedClone.getBoundingClientRect(),rectRemoveArea=removeDeviceArea.getBoundingClientRect();this.isIntersecting(rectClone,rectRemoveArea)?removeDeviceArea.classList.add("drag-over"):removeDeviceArea.classList.remove("drag-over");const x=touchLocation.clientX,y=touchLocation.clientY,hoveredElement=document.elementFromPoint(x,y);this.lastHoveredRoom&&(this.lastHoveredRoom.classList.remove("hoveredOver"),this.lastHoveredRoom=void 0),hoveredElement&&(hoveredElement.classList.contains("roomItemView")?this.hoveredRoom=hoveredElement:this.hoveredRoom=hoveredElement.closest(".roomItemView"),this.hoveredRoom&&(this.lastHoveredRoom=this.hoveredRoom,this.hoveredRoom.classList.add("hoveredOver")))}debouncedSaveLocalStorageToUserParameter()},eventTouchEnd:async function(event){if(this.alreadyInRoom&&this.alreadyInRoom.remove("alreadyInRoom"),this.isMobileDevice){if(!this.$el[0].draggable)return}else if(event.currentTarget.draggable)return;this.isDragging&&this.eventDragEnd(event)},eventDragEnd:async function(event){let touchLocation,x,y;this.checkRemoveFavFromRoom(event),(touchLocation=event.type.startsWith("touch")?event.changedTouches[0]:event)&&(void 0!==screen.left&&void 0!==screen.top?(x=touchLocation.clientX-screen.left,y=touchLocation.clientY-screen.top):(x=touchLocation.clientX,y=touchLocation.clientY));let outer=document.querySelector("#deviceValueSettingsOuter");outer.classList.contains("hidden")||outer.classList.add("hidden");const element=document.elementFromPoint(x,y),roomListView=document.getElementById("roomList"),roomElement=checkTree("roomItemView",element),device=event.currentTarget,arrow=document.querySelector(".drag-arrow");let hasRoomChanged;if(this.RoomIdCurrent&&roomElement&&roomElement.attributes["data-roomid"]?hasRoomChanged=roomElement&&this.RoomIdCurrent!==roomElement.attributes["data-roomid"].value:this.GroupIdCurrent&&roomElement&&roomElement.attributes["data-group-id"]&&(hasRoomChanged=roomElement&&this.GroupIdCurrent!==roomElement.attributes["data-group-id"].value),void 0===hasRoomChanged||!0===hasRoomChanged)if(roomElement&&roomListView)if(arrow){arrow.insertAdjacentElement("afterend",device);const index=Array.from(device.parentNode.children).indexOf(device);console.log("index: "+index),this.addOrRemoveDeviceFromResourceLinks(roomElement,index,hasRoomChanged)}else this.removeDeviceFromAllResources(),await this.addDeviceToRoom(roomElement);else this.parentRoomView&&("groups"===this.type?roomListView.querySelectorAll(".roomItemView").forEach(item=>item.classList.remove("alreadyInRoom")):screenMax(SCREEN_MAX_WIDTH_PHONE_LANDSCAPE)&&isThisPortrait()?document.querySelector(".removeDeviceArea").classList.contains("drag-over")&&(this.removeDeviceFromAllResources(),this.deleteDeviceFromAllGroupsAfterMoved(this.deviceLink,this.RoomIdCurrent)):(this.removeDeviceFromAllResources(),this.deleteDeviceFromAllGroupsAfterMoved(this.deviceLink,this.RoomIdCurrent)));else if(!1===hasRoomChanged&&arrow){arrow.insertAdjacentElement("afterend",device);const index=Array.from(device.parentNode.children).indexOf(device);this.addOrRemoveDeviceFromResourceLinks(roomElement,index,hasRoomChanged)}device.classList.remove("dragging");const removeDeviceArea=document.querySelector(".removeDeviceArea");if(removeDeviceArea&&(removeDeviceArea.classList.remove("drag-over"),removeDeviceArea.classList.add("hidden")),this.draggedClone&&(this.draggedClone.remove(),this.draggedClone=null),null!==arrow)for(let i=0;i<arrow.length;i++)arrow[i].remove();roomListView&&roomListView.querySelectorAll(".roomItemView").forEach(item=>{item.classList.remove("alreadyInRoom"),item.classList.remove("alreadyInRoom","hovered"),this.el=null}),this.quickBar.classList.remove("hideQuickbar")},deleteDeviceFromAllGroupsAfterMoved:function(deviceLink,roomId){console.log("remove "+deviceLink+" from all groups inside the room");let rl=app.resourcelinks.where({name:"room "+roomId})[0];rl&&rl.get("links").forEach(link=>{if(link.includes("groups")){let groupId=link.split("/")[2],subGroup=!0;this.removeDeviceFromGroup(deviceLink,groupId,subGroup)}});let onOffGroup=app.groups.where({name:"phoscon_room_"+roomId+"_on_off_group"})[0];onOffGroup&&this.removeDeviceFromGroup(deviceLink,onOffGroup.id)},updateDraggedClonePosition:function(touchLocation){this.draggedClone&&(this.draggedClone.style.position="absolute",this.draggedClone.style.pointerEvents="none",this.draggedClone.style.left=`${touchLocation.pageX}`,this.draggedClone.style.top=`${touchLocation.pageY}`)},createArrow:function(event){if(!this.parentRoomView)return;let deviceList=this.parentRoomView.deviceList;if(!deviceList)return;if(!(deviceList instanceof HTMLElement))return void console.warn("Device list is not a valid DOM element.");let clientX,clientY,arrow=deviceList.querySelector(".drag-arrow");if(!arrow){(arrow=document.createElement("div")).classList.add("drag-arrow");event.currentTarget;deviceList.appendChild(arrow)}"ontouchstart"in window&&event instanceof TouchEvent?(clientX=event.touches[0].clientX,clientY=event.touches[0].clientY):event instanceof MouseEvent&&(clientX=event.clientX,clientY=event.clientY),requestAnimationFrame(()=>{const children=[...deviceList.children],afterElement=this.getDragAfterElement(children,clientX,clientY);afterElement?deviceList.insertBefore(arrow,afterElement):deviceList.appendChild(arrow)})},getDragAfterElement:function(container,x,y){const draggableElements=[...container].filter(child=>child.classList.contains("deviceItemView")&&!child.classList.contains("dragging"));let closest=null,closestDistance=Number.POSITIVE_INFINITY;return draggableElements.forEach(child=>{const box=child.getBoundingClientRect(),childCenterX=box.left+box.width/2,childCenterY=box.top+box.height/2,distanceX=x-childCenterX,distanceY=y-childCenterY,distance=Math.sqrt(distanceX*distanceX+distanceY*distanceY);distance<closestDistance&&(closestDistance=distance,closest=child)}),closest},removeHightlightsAndClones:function(){document.getElementById("roomList")&&(document.getElementById("roomList").querySelectorAll(".roomItemView").forEach(item=>{item.classList.remove("alreadyInRoom","hovered")}),this.draggedClone&&this.draggedClone.remove(),this.draggedClone=null)},removeDeviceFromAllResources:async function(hasRoomChanged){let linkIndex;if(null!==this.parentRoomView&&void 0!==this.parentRoomView){if(void 0===this.parentRoomView.resourcelink){if(console.log("remove device from group"),hasRoomChanged)return void this.removeDeviceFromGroup(this.deviceLink,this.parentRoomView.model.get("id"))}else linkIndex=this.parentRoomView.resourcelink.attributes.links.indexOf(this.deviceLink);-1!==linkIndex&&(this.parentRoomView.resourcelink.attributes.links.splice(linkIndex,1),restUpdateResource(this.parentRoomView.resourcelink,{links:this.parentRoomView.resourcelink.attributes.links}).then(()=>{this.$el.remove()}),console.log("remove device from room"),this.removeDeviceFromGroup(this.deviceLink,this.parentRoomView.model.get("id")),this.isButtonClickDevice=!0)}else console.log("add device to room")},removeDeviceFromGroup:function(deviceLink,gid,subGroup){let group=app.groups.get(gid),room=app.rooms.get(gid),deviceType=deviceLink.split("/")[1],deviceId=deviceLink.split("/")[2];if("lights"===deviceType){let deviceList=group.get("lights"),l=app.lights.get(deviceId);if(!l)return;deviceList.includes(deviceId)?(console.log("delete light "+deviceId+" from group "+gid),deviceList.splice(deviceList.indexOf(deviceId),1),"FLS-PP3"===l.get("modelid")&&(l=getFlsPpWhite(l))&&-1!==deviceList.indexOf(l.id)&&deviceList.splice(deviceList.indexOf(l.id),1)):"FLS-PP3"===l.get("modelid")&&(l=getFlsPpWhite(l))&&-1!==deviceList.indexOf(l.id)&&deviceList.splice(deviceList.indexOf(l.id),1),group.save({lights:deviceList}).then(()=>{(group.get("name").includes("_on_off_group")||!0===subGroup)&&checkFlsSpecialGroups(group)}).then(()=>{console.log(`Group ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating group ${gid}:`,error)})}else if("blinds"===deviceType){if(!room)return;let deviceList=room.get("blinds");console.log("deivice list: "+deviceList),deviceList.includes(deviceId)&&(console.log("delete blind "+deviceId+" from room "+gid),deviceList.splice(deviceList.indexOf(deviceId),1)),room.save({blinds:deviceList}).then(()=>{console.log(`Room ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating room ${gid}:`,error)})}else if("thermostats"===deviceType){if(!room)return;let deviceList=room.get("thermostats");console.log("deivice list: "+deviceList),deviceList.includes(deviceId)&&(console.log("delete thermostat "+deviceId+" from room "+gid),deviceList.splice(deviceList.indexOf(deviceId),1)),room.save({thermostats:deviceList}).then(()=>{console.log(`Room ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating room ${gid}:`,error)})}},addDeviceToGroup:function(deviceLink,gid){let group=app.groups.get(gid),room=app.rooms.get(gid),deviceType=deviceLink.split("/")[1],deviceId=deviceLink.split("/")[2];if("lights"===deviceType){let deviceList=group.get("lights"),l=app.lights.get(deviceId);if(!l)return;deviceList.includes(deviceId)||(console.log("add light "+deviceId+" to group "+gid),deviceList.push(deviceId),"FLS-PP3"===l.get("modelid")&&(l=getFlsPpWhite(l))&&-1===deviceList.indexOf(l.id)&&deviceList.push(l.id)),group.save({lights:deviceList}).then(()=>{group.get("name").includes("_on_off_group")&&checkFlsSpecialGroups(group)}).then(()=>{console.log(`Group ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating group ${gid}:`,error)})}else if("blinds"===deviceType){if(!room)return;let deviceList=room.get("blinds");console.log("deivice list: "+deviceList),deviceList.includes(deviceId)||(console.log("add blind "+deviceId+" to room "+gid),deviceList.push(deviceId)),room.save({blinds:deviceList}).then(()=>{console.log(`Room ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating room ${gid}:`,error)})}else if("thermostats"===deviceType){if(!room)return;let deviceList=room.get("thermostats");console.log("deivice list: "+deviceList),deviceList.includes(deviceId)||(console.log("add thermostat "+deviceId+" to room "+gid),deviceList.push(deviceId)),room.save({thermostats:deviceList}).then(()=>{console.log(`Room ${gid} updated successfully`)}).catch(error=>{console.error(`Error updating room ${gid}:`,error)})}},eventRemoveDevice:function(event){event.preventDefault(),event.stopPropagation(),this.handleEventPropagation(event),"groups"!==this.type&&(this.removeDeviceFromAllResources(),this.removeDeviceCheck=!0)},eventRemoveDeviceFromRoom:function(event){let type;event.preventDefault(),event.stopPropagation();let id=this.model.attributes.id;const resourceLink=this.parentRoomView.resourcelink;this.model.attributes.type.includes("light")&&(type="lights"),this.model.attributes.type.includes("Window")&&(type="blinds"),this.model.attributes.type.includes("plug")&&(type="lights"),this.model.attributes.type.includes("Day")&&(type="sensors"),this.model.attributes.type.includes("ZHA")&&(type="sensors");const requestData={links:resourceLink.attributes.links.filter(link=>{const linkType=link.split("/")[1],linkId=link.split("/")[2];return linkType!==type||linkId!==id.toString()})};restUpdateResource(this.parentRoomView.resourcelink,requestData).then(()=>{this.el.remove()}).catch(error=>{console.error("Error removing device from room:",error)}),this.isButtonClickDevice=!0},addOrRemoveDeviceFromResourceLinks:async function(roomElement,index,hasRoomChanged){if(void 0===hasRoomChanged&&(hasRoomChanged=!0),!roomElement)return;const resourcelink=app.resourcelinks.get(roomElement.dataset.resourceid);var roomChanged=hasRoomChanged;if(resourcelink){for(const rl of app.resourcelinks.models){const linkIndex=rl.attributes.links.indexOf(this.deviceLink);-1!==linkIndex&&(rl.attributes.links.splice(linkIndex,1),await restUpdateResource(rl,{links:rl.attributes.links}),!0===roomChanged&&(this.removeDeviceFromGroup(this.deviceLink,rl.get("name").split("room ")[1]),this.deleteDeviceFromAllGroupsAfterMoved(this.deviceLink,rl.get("name").split("room ")[1])))}if(!resourcelink.attributes.links.includes(this.deviceLink)&&(resourcelink.attributes.links.splice(index-1,0,this.deviceLink),await restUpdateResource(resourcelink,{links:resourcelink.attributes.links}),hasRoomChanged&&(this.addDeviceToGroup(this.deviceLink,roomElement.dataset.roomid),this.deviceLink.includes("lights")))){let light=app.lights.get(this.deviceLink.split("/")[2]);if(light&&("dimmable plug-in unit"===light.get("type")||!light.get("type").includes("plug"))){let onOffGroup=app.groups.where({name:"phoscon_room_"+roomElement.dataset.roomid+"_on_off_group"})[0];onOffGroup&&this.addDeviceToGroup(this.deviceLink,onOffGroup.id)}}app.roomViews.refreshRooms();let savedPosition=localStorage.getItem("scrollPosition");savedPosition&&(mainContainer.scrollTop=savedPosition)}},addDeviceToRoom:async function(roomElement){app.roomViews.views.forEach(view=>{view.el==roomElement&&(view.expanded=!0,localStorage.setItem(`${view.roomid}_expanded`,!0),debouncedSaveLocalStorageToUserParameter())}),await this.addOrRemoveDeviceFromResourceLinks(roomElement)}});