var apikey = null;
var apiversion = 'vnd.ddel.v1';
var isFocused = false;
var curEdit = {};
var curDevice = {};
var old = {};
var curRules = [];
var allLights = [];
var allGroups = [];
var allScenes = [];
var numberOfDevices = 0;
var allDeviceIds = [];
var zigBeeChannel = 0;
var UPDATE_DEVICES_INTERVAL = 3000;
var deviceNotFoundTimeout;
var countDownTimer;
var config;
var lightingSwitchMode = "2";
var reloadCount = 0;
var supportedDevices = ["Scene Switch","Lighting Switch","RWL020","RWL021","ZGPSWITCH","S1","S2","D1","C4"]

/**
 * Init touch and small displays.
 */
function devicesInit() {
    // check if this is mobile or desktop
    // and load custom js and css files

    if (Modernizr.touch) {
        loadjscssfile("mobile.css", "css");
        isDesktop = false;
    }
    else {
        isDesktop = true;
        loadjscssfile("desktop.css", "css");
    }

    if (Modernizr.touch) {
        clickevent = "touchend";
        pointerStart = "touchstart";
        pointerEnd = "touchend";
        pointerMove = "touchmove";
    }
}

/**
 * Init the base branding of the interface.
 */
function initBranding() {

    var customBrand = false;

    var navName = "Wireless Light";

    if (customBrand) {
        var navName = "CUSTOM <span style=\"position: relative; display: inline-block; bottom: 8px;\">&reg;</span>";
        var brand = '<span class="custom-brand">' + navName + '</span>';
        $(".navbar-inner .brand").html(brand);
    }
}

/**
* build the html page for a given Sensor Object.
*/
function buildSubPageForTap() {

    var rowtxt = '<div class="location span6" style="margin:0px; padding:15px 0;">';
    rowtxt += '<div class="row-fluid">';
    rowtxt += '<table align="center" border="0" style="width:90%">';
    rowtxt += '<tbody style="margin:0;padding:0;">';

    //name
    rowtxt += '<tr><td>Name</td><td colspan="2"><form class="inner-addon right-addon navbar-form pull-left"><img style="" class="glyphicon" src="img/pencil.png"></img><input id="devNameLabelBig" type="text" style="margin-left:0px;width:88%;" maxlength="32" value="' + curDevice.name + '"></form></td></tr>';

    rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';
    //button assignment
    //4 buttons for Hue Tap

    //button 1
    rowtxt += '<tr class="buttonRow" id="0"><td><img src="img/hue-btn1-large.png" /></td><td style="white-space:normal;"><select class="selectFunction" id="selectFunction0" >';
    rowtxt += '<option value="1">All Lights Off</option><option value="2">All Lights On</option><option value="3">Group Off</option><option value="4">Group On</option><option value="5">Call Scene</option></select>';
    rowtxt += '<select class="selectTarget" id="selectTarget0" ></select></td></tr>';
    rowtxt += '<tr><td colspan="2">&nbsp;</td></tr>';

    //button 2
    rowtxt += '<tr class="buttonRow" id="1"><td><img src="img/hue-btn2-large.png" /></td><td style="white-space:normal;"><select class="selectFunction" id="selectFunction1" >';
    rowtxt += '<option value="1">All Lights Off</option><option value="2">All Lights On</option><option value="3">Group Off</option><option value="4">Group On</option><option value="5">Call Scene</option></select>';
    rowtxt += '<select class="selectTarget" id="selectTarget1" ></select></td></tr>';
    rowtxt += '<tr><td colspan="2">&nbsp;</td></tr>';

    //button 3
    rowtxt += '<tr class="buttonRow" id="2"><td><img src="img/hue-btn3-large.png" /></td><td style="white-space:normal;"><select class="selectFunction" id="selectFunction2" >';
    rowtxt += '<option value="1">All Lights Off</option><option value="2">All Lights On</option><option value="3">Group Off</option><option value="4">Group On</option><option value="5">Call Scene</option></select>';
    rowtxt += '<select class="selectTarget" id="selectTarget2" ></select></td></tr>';
    rowtxt += '<tr><td colspan="2">&nbsp;</td></tr>';

    //button 4
    rowtxt += '<tr class="buttonRow" id="3"><td><img src="img/hue-btn4-large.png" /></td><td style="white-space:normal;"><select class="selectFunction" id="selectFunction3" >';
    rowtxt += '<option value="1">All Lights Off</option><option value="2">All Lights On</option><option value="3">Group Off</option><option value="4">Group On</option><option value="5">Call Scene</option></select>';
    rowtxt += '<select class="selectTarget" id="selectTarget3" ></select></td></tr>';
    rowtxt += '<tr><td colspan="2">&nbsp;</td></tr>';

    //delete
    rowtxt += '<tr><td><span class="btn btn-danger deleteButton" style="margin: 15px 0px;">Delete</span></td>';

    //apply/done
    rowtxt += '<td colspan="2"align="right"><span class="btn btn-primary saveButton" style="margin: 15px 0px;">Apply</span>&nbsp;&nbsp;&nbsp;<span class="btn actionButton doneButton" style="margin: 15px 0px;">Cancel</span></td></tr>';

    rowtxt += '</tbody></table></div></div>';

    pageLightList.innerHTML = "";
    pageLightList.innerHTML += rowtxt;

    //select the current option for each button for hue tap
    for (r in curRules) {
        if ((curRules[r].actions[0].address).indexOf("/groups/0/") != -1) {
            if (curRules[r].actions[0].body.on == false) {
                $('#selectFunction'+r).val('1');
            } else {
                $('#selectFunction'+r).val('2');
            }
        } else if ((curRules[r].actions[0].address).indexOf("/scenes/") != -1) {
            $('#selectFunction'+r).val('5');
        } else {
            if (curRules[r].actions[0].body.on == false) {
                $('#selectFunction'+r).val('3');
            } else {
                $('#selectFunction'+r).val('4');
            }
        }
    }

    //fill the selects with groups and scenes
    $(".selectFunction").each(function(i) {
        if (($('option:selected', this).val() == "1") || ($('option:selected', this).val() == "2")) {
            $('#selectTarget'+i).html('<option value="0">&#10003;</option>');
        } else if (($('option:selected', this).val() == "3") || ($('option:selected', this).val() == "4")) {
            var a = curRules[i].actions[0].address;
            var curGroup = a.substring(a.indexOf("/groups/")+8,a.indexOf("/action"));
            if (allGroups.length === 0) {
                $('#selectTarget'+i).append("<option value=\"X\">No Group found</option>");
            } else {
                for (option in allGroups) {
                    $('#selectTarget'+i).append(allGroups[option]);
                    $('#selectTarget'+i).val(curGroup);
                }
            }
        } else if ($('option:selected', this).val() == "5") {
            var a = curRules[i].actions[0].address;
            var curGroup = a.substring(a.indexOf("/groups/")+8,a.indexOf("/scenes"));
            var curScene = a.substring(a.indexOf("/scenes/")+8,a.indexOf("/recall"));

            if (allScenes.length === 0) {
                $('#selectTarget'+i).append("<option value=\"X\">No Scene found</option>");
            } else {
                for (option in allScenes) {
                    $('#selectTarget'+i).append(allScenes[option]);
                    $('#selectTarget'+i).val(curGroup + "-" + curScene);
                }
            }
        }
    });

    old.selectTarget0 = $('#selectTarget0').val();
    old.selectFunction0 = $('#selectFunction0').val();
    old.selectTarget1 = $('#selectTarget1').val();
    old.selectFunction1 = $('#selectFunction1').val();
    old.selectTarget2 = $('#selectTarget2').val();
    old.selectFunction2 = $('#selectFunction2').val();
    old.selectTarget3 = $('#selectTarget3').val();
    old.selectFunction3 = $('#selectFunction3').val();
    old.name = $('#devNameLabelBig').val();
}

/**
* build the html page for a given Sensor Object.
*/
function buildSubPageForSwitch() {

    var rowtxt = '<div class="location span6" style="margin:0px; padding:15px 0;">';
    rowtxt += '<div class="row-fluid">';
    rowtxt += '<table align="center" border="0" style="width:90%">';
    rowtxt += '<tbody style="margin:0;padding:0;">';

    //name
    rowtxt += '<tr><td>Name</td><td colspan="2"><form class="inner-addon right-addon navbar-form pull-left"><img class="glyphicon" src="img/pencil.png" /><input id="devNameLabelBig" type="text" style="margin-left:0px;" maxlength="32" value="' + curDevice.name + '"></form></td></tr>';

    //group
    var c = 0;
    if (sessionStorage.getItem("reloadCount-" + curDevice.id)) {
        reloadCount = parseInt(sessionStorage.getItem("reloadCount-" + curDevice.id));
    }
    for (g in curDevice.groupIds) {
        c++;
        if (c >= 2 && curDevice.mode != 2) {
            saveGroupHiddenStatus(curDevice.groupIds[g],true);
        }

        var hiddenClass = "";
        var placeHolder = " hidden";
        if (config.groups[curDevice.groupIds[g]].hidden === true) {
            hiddenClass = " hidden";
            placeHolder = "";
        }

        rowtxt += '<tr class="groupRow' + hiddenClass + '">';
        if (curDevice.groupIds.length > 1) {
            rowtxt += '<td>Group ' + c + '</td>';
        } else {
            rowtxt += '<td>Group</td>';
        }
        rowtxt += '<td style="white-space:normal;" colspan="2"><form class="inner-addon right-addon navbar-form pull-left"><img class="glyphicon" src="img/pencil.png" /><input id="'+ curDevice.groupIds[g] +'" class="groupNameLabel" type="text" style="margin-left:0px;text-align:center;" maxlength="32" value="' + config.groups[curDevice.groupIds[g]].name + '"></form> &nbsp;&nbsp;<a href="edit_group_members.html?group='+ curDevice.groupIds[g] +'" class="btn add-lights-btn" style="margin-top:5px;">Add lights</a></td></tr>';

    }
    if (c === 0 &&
        //don't display group creation info for switches that don't create groups
        (curDevice.manufacturername != "ubisys" && curDevice.manufacturername != "BEGA Gantenbrink-Leuchten KG") && curDevice.manufacturername != "OSRAM" && curDevice.manufacturername != "GREEBLE") {
        if (reloadCount < 12) {
            setTimeout(function(){location.reload(true)},6000);
        }
        if (reloadCount >= 0 && reloadCount < 12) {
            rowtxt += '<tr><td></td><td colspan="2" style="white-space:normal;"><br />Group is being created...</td></tr>';
        }
        if (reloadCount >= 3 && reloadCount < 12) {
            rowtxt += '<tr><td></td><td colspan="2" style="white-space:normal;">This can take up to 1 minute.</td></tr>';
        }
        if (reloadCount >= 12) {
            rowtxt += '<tr><td></td><td colspan="2" style="white-space:normal;"><br />Group creation Error.<br />Please delete and reconnect the switch.</td></tr>';
        }
        if (reloadCount < 12) {
            reloadCount++;
            sessionStorage.setItem("reloadCount-" + curDevice.id, reloadCount);
        }
    } else {
        if (sessionStorage.getItem("reloadCount-" + curDevice.id)) {
            sessionStorage.removeItem("reloadCount-" + curDevice.id);
        }
    }

    var h = "35px";
    if (isSmallDevice) {
        h = "70px";
    }
    rowtxt += '<tr class="placeholder' + placeHolder + '" style="height:'+ h +';line-height:'+ h +';"><td colspan="3">&nbsp;</td></tr>';
    rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';

    //rules / bindings
    if (curDevice.manufacturername === "ubisys" || curDevice.manufacturername === "BEGA Gantenbrink-Leuchten KG") {
        var ruleCount = 0;
        var eps = getURLParameter("ep");
        var epList = eps.split(",");
        for (p in epList) {
            var count = 0;
            var ep = epList[p];
            var sid = ep.substring(0,ep.indexOf("-"));
            ep = ep.substring(ep.indexOf("-")+1,ep.length);
            rowtxt += '<tr style="border-bottom:solid 1px white;" id="ep-'+ ep +'"><td colspan="3">Button ' + (parseInt(p)+1) + ' </td></tr>';

            //create entry for existing Rule
            for (c in curRules) {
                if (curRules[c].conditions[0].value == ep) {
                    var bnd;
                    for (property in curRules[c].actions[0].body) {
                        bnd = (property == "on") ? "On/Off" : (property == "bri") ? "Dim" : "Scene";
                    }
                    rowtxt += '<tr id="'+ c +'" data-ep="'+ ep +'" data-sid="'+ sid +'"><td><span id="bnd-'+c+'">'+ bnd +'</span></td><td style="white-space:normal;" colspan="2"><select class="lightOrGroup" style="width:120px;margin-top:10px;" id="lightOrGroup'+ c +'"><option value="1">Light</option><option value="2">Group</option><option value="3">Deactivate</option></select> <select class="lightOrGroupSelect" id="selectLightOrGroup'+ c +'" style="width:198px; margin-top:10px;"></select></td></tr>';
                    count++;
                }
            }

            if (count === 0) {
                //create dummy entry for non existing rule based on switch model
                if (curDevice.modelid.indexOf("D1") == 0) {
                    // On/Off & Dim
                    var n = curRules.length + ruleCount;
                    rowtxt += '<tr id="'+ n +'" data-ep="'+ ep +'" data-sid="'+ sid +'"><td><span id="bnd-'+n+'">On/Off</span></td><td colspan="2" style="white-space:normal;"><select class="lightOrGroup" style="width:120px;margin-top:10px;" id="lightOrGroup'+ n +'"><option value="1">Light</option><option value="2">Group</option></select> <select class="lightOrGroupSelect" id="selectLightOrGroup'+ n +'" style="width:198px; margin-top:10px;"></select></td></tr>';
                    rowtxt += '<tr id="'+ (n+1) +'" data-ep="'+ ep +'" data-sid="'+ sid +'"><td><span id="bnd-'+(n+1)+'">Dim</span></td><td colspan="2" style="white-space:normal;"><select class="lightOrGroup" style="width:120px;margin-top:10px;" id="lightOrGroup'+ (n+1) +'"><option value="1">Light</option><option value="2">Group</option></select> <select class="lightOrGroupSelect" id="selectLightOrGroup'+ (n+1) +'" style="width:198px; margin-top:10px;"></select></td></tr>';
                    ruleCount += 2;
                } else if (curDevice.modelid.indexOf("S2") == 0 || curDevice.modelid.indexOf("S1") == 0 ||
                    curDevice.manufacturername.indexOf("BEGA") == 0 || curDevice.modelid.indexOf("C4") == 0) {
                    // On/Off
                    var n = curRules.length + ruleCount;
                    rowtxt += '<tr id="'+ n +'" data-ep="'+ ep +'" data-sid="'+ sid +'"><td><span id="bnd-'+n+'">On/Off</span></td><td colspan="2" style="white-space:normal;"><select class="lightOrGroup" style="width:120px;margin-top:10px;" id="lightOrGroup'+ n +'"><option value="1">Light</option><option value="2">Group</option></select> <select class="lightOrGroupSelect" id="selectLightOrGroup'+ n +'" style="width:198px; margin-top:10px;"></select></td></tr>';
                    ruleCount += 1;
                }
            }
        }
    }
    rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';

    //picture
    if (curDevice.modelid === "Scene Switch") {
        rowtxt += '<tr><td></td><td colspan="2" align="left"><img src="img/zhaswitch3_big.png" style="width:90%;max-width:260px;" /></td></tr>';
        rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';
    }
    else if (curDevice.modelid === "RWL021") {
        rowtxt += '<tr><td></td><td colspan="2" align="left"><img src="img/rwl_big_white.png" /></td></tr>';
        rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';
    }
    else if (curDevice.modelid === "Lighting Switch") {

        var hiddenClass = "";
        var dots = "";

        if (curDevice.mode != undefined) {
            lightingSwitchMode = curDevice.mode;
        }

        var modeText = (lightingSwitchMode == 1) ? "Scenes" : (lightingSwitchMode == 2) ? "Two Groups" : "Color Temperature";

        rowtxt += '<tr><td></td><td colspan="2">';

        hiddenClass = (lightingSwitchMode == 1) ? "" : "hidden";
        rowtxt += '<img id="pic_1" class="switch_pic '+ hiddenClass +'" src="img/zhaswitch2_big_scenes.png" style="width:90%;max-width:260px;" />';

        hiddenClass = (lightingSwitchMode == 2) ? "" : "hidden";
        rowtxt += '<img id="pic_2" class="switch_pic '+ hiddenClass +'" src="img/zhaswitch2_big_groups.png" style="width:90%;max-width:260px;" />';

        hiddenClass = (lightingSwitchMode == 3) ? "" : "hidden";
        rowtxt += '<img id="pic_3" class="switch_pic '+ hiddenClass +'" src="img/zhaswitch2_big_wwcw.png" style="width:90%;max-width:260px;" />';

        rowtxt += '</tr></td>';

        rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';
        rowtxt += '<tr><td>Mode</td><td style="white-space:normal;">' + modeText + ' </td><td><button style="float:right;" class="btn" id="changeMode-btn">Change Mode</button></td></tr>';
        rowtxt += '<tr><td colspan="3">&nbsp;</td></tr>';
    }

    //battery
    //rowtxt += '<tr><td>Battery</td><td colspan="2">' + ' 100% ' + '</td></tr>';

    //manufacturer
    if (curDevice.manufacturername != "" && curDevice.manufacturername != "unknown") {
        rowtxt += '<tr><td>Vendor</td><td colspan="2" style="white-space:normal;">' + curDevice.manufacturername + '</td></tr>';
    }

    //model
    if (curDevice.modelid != "") {
        rowtxt += '<tr><td>Model</td><td colspan="2">' + curDevice.modelid + '</td></tr>';
    }
    //swVersion
    if (curDevice.swversion) {
        rowtxt += '<tr><td>Version</td><td colspan="2">' + curDevice.swversion + '</td>';
        //rowtxt += '<td><button class="btn" id="fwUpdate-btn">Update<button></td>';
        rowtxt += '</tr>';
    }

    //delete
    rowtxt += '<tr><td><span class="btn btn-danger deleteButton" style="margin: 15px 0px;">Delete</span></td>';

    //apply/done
    rowtxt += '<td colspan="2"align="right"><span class="btn btn-primary saveButton" style="margin: 15px 0px;">Apply</span>&nbsp;&nbsp;&nbsp;<span class="btn actionButton doneButton" style="margin: 15px 0px;">Cancel</span></td></tr>';

    rowtxt += '</tbody></table></div></div>';

    pageLightList.innerHTML = "";
    pageLightList.innerHTML += rowtxt;

    //select the current option for group or light select
    for (r in curRules) {
        var addr = curRules[r].actions[0].address;
        var ep = curRules[r].conditions[0].value;
        var lightOrGroup = (addr.indexOf("lights") != -1) ? 1 : 2;

        if (lightOrGroup == 1) {
            $('#lightOrGroup'+r).val('1');
        } else {
            $('#lightOrGroup'+r).val('2');
        }
    }

    //fill the selects with groups or lights or scenes
    $(".lightOrGroup").each(function(i) {
        if (curRules[i] != undefined) {
            // if rule exists
            var addr = curRules[i].actions[0].address;
            var ep = curRules[i].conditions[0].value;
            var id = (/\d+/.exec(addr.substring(8,addr.length)))[0];

            if (($('#lightOrGroup' + i + ' option:selected').val() == "1")) {
                if (allLights.length === 0) {
                    $('#selectLightOrGroup'+i).append("<option value=\"X\">No Lights found</option>");
                } else {
                    for (option in allLights) {
                        $('#selectLightOrGroup'+i).append(allLights[option]);
                        $('#selectLightOrGroup'+i).val(id);
                    }
                }
            } else {
                if (allGroups.length === 0) {
                    $('#selectLightOrGroup'+i).append("<option value=\"X\">No Groups found</option>");
                } else {
                    for (option in allGroups) {
                        $('#selectLightOrGroup'+i).append(allGroups[option]);
                        $('#selectLightOrGroup'+i).val(id);
                    }
                }
            }
        } else {
            // if rule does not exists
            if (($('#lightOrGroup' + i + ' option:selected').val() == "1")) {
                if (allLights.length === 0) {
                    $('#selectLightOrGroup'+i).append("<option value=\"X\">No Lights found</option>");
                } else {
                    for (option in allLights) {
                        $('#selectLightOrGroup'+i).append(allLights[option]);
                        $('#selectLightOrGroup'+i).val('0'); // shows that rule does not exist yet
                    }
                }
            } else {
                if (allGroups.length === 0) {
                    $('#selectLightOrGroup'+i).append("<option value=\"X\">No Groups found</option>");
                } else {
                    for (option in allGroups) {
                        $('#selectLightOrGroup'+i).append(allGroups[option]);
                        $('#selectLightOrGroup'+i).val('0'); // shows that rule does not exist yet
                    }
                }
            }
        }
    });

    old.name = $('#devNameLabelBig').val();
}

/**
* adds html to the Devices index page.
*/
function showDevices(sensors) {
    var devices = [];
    var device = {};
    var deviceIcon = "";
    var uniqueIds = [];
    var rowtxt = "";
    rowtxt += '<div class="location span6" style="margin-left:0px;">';
    rowtxt += '<div class="row-fluid">';
    rowtxt += '<table border="0" id="deviceTable">';
    rowtxt += '<tbody>';

    for (key in sensors) {
        device = sensors[key];
        device.id = key;
        if (!device.uniqueid)
            continue;

        var uid = device.uniqueid.split('-');

        if (uid.length < 2)
            continue;

        if (!_.contains(uniqueIds, uid[0])) {
            // add new sensor
            device.ep = device.id + "-" + uid[1]; // id-ep pair
            uniqueIds[uniqueIds.length] = uid[0];
            devices[devices.length] = device;
        } else {
            // sensor already exists. Add endpoint.
            for (d in devices) {
                if (devices[d].uniqueid.indexOf(uid[0]) === 0) {
                    devices[d].ep = devices[d].ep + "," + device.id + "-" + uid[1];
                    break;
                }
            }
        }
    }

    for (de in devices) {
        device = devices[de];

        if (!device.modelid)
            continue;

        var supported = false;
        for (var d in supportedDevices) {
            if (device.modelid.indexOf(supportedDevices[d]) != -1) {
                supported = true;
                break;
            }
        }

        //switches
        if ((device.type === "ZGPSwitch" || device.type === "ZHASwitch") && ( supported === true )) {
            if (device.type === "ZGPSwitch") {
                deviceIcon = "<img src=\"img/huetap.png\">";
            } else if (device.type === "ZHASwitch") {
                deviceIcon = "<img src=\"img/zhaswitch2_small.png\">";
                if (device.modelid === "RWL020" || device.modelid === "RWL021") {
                    deviceIcon = "<img src=\"img/rwl_small.png\" style=\"margin-top:-3px;\"/> ";
                }
                if (device.modelid == "Scene Switch") {
                    deviceIcon = "<img src=\"img/zhaswitch3_small.png\" style=\"margin-top:-3px;\"/> ";
                }
            }
            rowtxt += '<tr class="light_item" style=""><td style="width:12%">' + deviceIcon + '</td><td style="width:10px;"></td>';
            rowtxt += '<td>' + device.name + '</td>';
            rowtxt += '<td style="" class="edit_button" data-ep="'+ device.ep +'" data-did="' + device.id + '"></td></tr>';
            rowtxt += "<tr><td colspan=\"4\">&nbsp;</td></tr>";

        } else if ((device.type === "ZHAPresence" || device.type.indexOf("ZHALight") !== -1)
            && (device.modelid.indexOf("FLS-NB") != -1)) {
            //sensors
        }
    }

    rowtxt += '</tbody>';
    rowtxt += '</table>';
    if (Modernizr.localstorage && localStorage.getItem("de-gw-swVersion") != undefined) {
        var swVersion = localStorage.getItem("de-gw-swVersion");
        rowtxt += '<div class="button-toolbar pull-right" style="padding-top:20px;padding-bottom:10px;"><span class="btn btn-primary connect_btn">Connect a Device</span>&nbsp;<a class="btn" href="/index.html?v=' + swVersion + '">Done</a></div>';
    } else {
        rowtxt += '<div class="button-toolbar pull-right" style="padding:20px 0px;"><span class="btn btn-primary connect_btn">Connect a Device</span>&nbsp;<a class="btn" href="/index.html">Done</a></div>';
    }
    rowtxt += '</div>';
    rowtxt += '</div>';

    $("#pageLightList").html("");
    $("#pageLightList").html(rowtxt);


    adjustLightNames();
}


/**
 * Helper to adjust the size of the name field to not exceed the table size.
 */
function adjustLightNames() {
    $('tr.light_item').each(function(index) {
            var maxwidth = $(this).innerWidth() - 180;
            $('.light_item td:nth-child(3)').each(function(index) {
                $(this).css('max-width', maxwidth + 'px');
            });
    });
}

/**
* api/<apikey>/sensors
*/
function getDevices() {

    $.ajax({
        url: 'api/' + apikey + '/sensors',
        dataType: 'json',
        type: 'GET',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        data: '',
        success: function(json, status, xhr) {
            curEdit.obj = json;
            numberOfDevices = 0;
            for (var d in json) {
                if (json[d].modelid != "") {
                    numberOfDevices++;
                }
            }
            allDeviceIds = Object.keys(json);
            showDevices(curEdit.obj);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            case 404: // not found go back
              window.location.assign("/");
              break;

            default:
              setTimeout(getDevices, 3000);
              showAlert('alert-error', '<b>Error!</b> Loading data, retry in three seconds ...');
              break;
            }
        },
        timeout: 10000
    });
}

/**
* Polling GW to get data on new connected devices
*/
function updateDevices() {
console.log("send REST API");
    $.ajax({
        url: 'api/' + apikey + '/sensors',
        dataType: 'json',
        type: 'GET',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        data: '',
        success: function(json, status, xhr) {
            if (numberOfDevices < Object.keys(json).length) {
                for (id in Object.keys(json)) {
                    var id = Object.keys(json)[id];
                    if (!(_.contains(allDeviceIds, id))) {
                        var modelid = json[id].modelid;
                        // show success only when device is supported
                        if (modelid && supportedDevices.indexOf(json[id].modelid) >= 0) {
                            showAlert('alert-success', '<b>Ok!</b> Found a new device', '#deviceFoundInfo');
                            clearTimeout(deviceNotFoundTimeout);
                            deviceNotFoundTimeout = null;
                            clearTimeout(countDownTimer);
                            countDownTimer = null;
                            $('#btnSearchNow').addClass("hidden");
                            if ($('#device_type').val() == 2) {
                                $('#doneButton').addClass("hidden");
                                $('#nextButton').removeClass("hidden");
                            }
                            if (modelid == "ZGPSWITCH") {
                                createHueTapRules(json[id].uniqueid, id);
                            }
							return;
                        }
                    }
                }
            }
			setTimeout(updateDevices, UPDATE_DEVICES_INTERVAL);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            case 404: // not found go back
              window.location.assign("/");
              break;

            default:
              setTimeout(getDevices, 3000);
              showAlert('alert-error', '<b>Error!</b> Loading data, retry in three seconds ...');
              break;
            }
        },
        timeout: 10000
    });
}

function showNext() {
    var txt = "<li>Now hold your switch near to a lamp.</li>";
    txt += "<li>Press the <b>I</b> button of the switch for about 10 seconds. The lamp starts to blink.</li>";
    txt += "<li>Do not release the <b>I</b> button until the LED on the front of the switch lights green.</li>";
    txt += "<li>Now you can close this window and add other lights to the switch group with the web app.</li>";
    $('#device-join-description').html(txt);
    $('#additional-text').html('<img style="margin-left:25px;" src="img/rwl_big_tl.png">');
    $('#nextButton').addClass("hidden");
    $('#doneButton').removeClass("hidden");
}

/**
 * create rules for a Hue Tap
 * /params uniqueid of sensor
 * /params id of sensor
 */
function createHueTapRules(uniqueid, id) {

    var rule = '{';
    rule += '"name":"' + uniqueid + '[Rule1]",';
    rule += '"status":"enabled",';
    rule += '"actions":[{"address":"/groups/0/action","method":"PUT","body":{"on":false}}],';
    rule += '"conditions":[{"address":"/sensors/' + id + '/state/buttonevent","operator":"eq","value":"34"},{"address":"/sensors/' + id + '/state/lastupdated","operator":"dx"}]';
    rule += '}';

    createRuleRest(rule);

    rule = '{';
    rule += '"name":"' + uniqueid + '[Rule2]",';
    rule += '"status":"enabled",';
    rule += '"actions":[{"address":"/groups/0/action","method":"PUT","body":{"on":true}}],';
    rule += '"conditions":[{"address":"/sensors/' + id + '/state/buttonevent","operator":"eq","value":"16"},{"address":"/sensors/' + id + '/state/lastupdated","operator":"dx"}]';
    rule += '}';

    createRuleRest(rule);

    rule = '{';
    rule += '"name":"' + uniqueid + '[Rule3]",';
    rule += '"status":"enabled",';
    rule += '"actions":[{"address":"/groups/0/action","method":"PUT","body":{"on":true}}],';
    rule += '"conditions":[{"address":"/sensors/' + id + '/state/buttonevent","operator":"eq","value":"17"},{"address":"/sensors/' + id + '/state/lastupdated","operator":"dx"}]';
    rule += '}';

    createRuleRest(rule);

    rule = '{';
    rule += '"name":"' + uniqueid + '[Rule4]",';
    rule += '"status":"enabled",';
    rule += '"actions":[{"address":"/groups/0/action","method":"PUT","body":{"on":true}}],';
    rule += '"conditions":[{"address":"/sensors/' + id + '/state/buttonevent","operator":"eq","value":"18"},{"address":"/sensors/' + id + '/state/lastupdated","operator":"dx"}]';
    rule += '}';

    createRuleRest(rule);
}

/**
* api/<apikey>/sensors/<id>
*/
function loadDevice(id) {

    $.ajax({
        url: 'api/' + apikey + '/sensors/' + id,
        dataType: 'json',
        type: 'GET',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        data: '',
        success: function(json, status, xhr) {
            curDevice = json;
            curDevice.id = id;

            config = JSON.parse(sessionStorage.config);
            var group;
            var groupIds = [];

            var sid;
            var epList = getURLParameter("ep").split(",");

            for (p in epList) {
                sid = epList[p].substring(0,epList[p].indexOf("-"));

                for (g in config.groups) {
                    group = config.groups[g];
                    if (group.devicemembership[0] == sid) {
                        groupIds[groupIds.length] = g;
                    }
                }
            }

            curDevice.groupIds = groupIds;

            loadRules();

        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            case 404: // not found go back
              window.location.assign("/");
              break;

            default:
              setTimeout(getDevices, 3000);
              showAlert('alert-error', '<b>Error!</b> Loading data, retry in three seconds ...');
              break;
            }
        },
        timeout: 10000
    });
}

/**
* api/<apikey>/rules
*/
function loadRules() {
    var rule;
    var idEp = "";
    var epList = [];
    curRules = [];
    if (curDevice.type === "ZGPSwitch") {
        curRules = [0,1,2,3];
    }
    $.ajax({
        url: 'api/' + apikey + '/rules',
        dataType: 'json',
        type: 'GET',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        data: '',
        success: function(json, status, xhr) {
            for(key in json) {
                rule = json[key];
                rule.id = key;

                if (curDevice.type === "ZGPSwitch") {
                    var id = getURLParameter("device");
                    if (rule.conditions[0].address.indexOf("/sensors/" + id + "/state/buttonevent") != -1) {
                        var n = rule.name.indexOf("Rule");
                        var pos = parseInt(rule.name.substr(n+4,1))-1;
                        curRules[pos] = rule;
                    }
                } else {
                    idEp = getURLParameter("ep");
                    epList = idEp.split(",");
                    for (e in epList) {
                        var id = epList[e].substring(0,epList[e].indexOf("-"));
                        if (rule.conditions[0].address.indexOf("/sensors/" + id + "/state/buttonevent") != -1) {
                            curRules[curRules.length] = rule;
                        }
                    }
                }
            }
            if (curDevice.type == "ZGPSwitch") {
                buildSubPageForTap();
            } else if (curDevice.type == "ZHASwitch") {
                buildSubPageForSwitch();
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            case 404: // not found go back
              window.location.assign("/");
              break;

            default:
              setTimeout(getDevices, 3000);
              showAlert('alert-error', '<b>Error!</b> Loading data, retry in three seconds ...');
              break;
            }
        },
        timeout: 10000
    });
}

/**
 * set rule parameter and call sendUpdateRuleRest()
 */
function updateRules() {
    var ruleId = "";
    var actionAddress = "";
    var actionBody = "";
    var sensorId = curDevice.id;

    // if name changed: update sensor name
    if (old.name != $('#devNameLabelBig').val()) {
        if ($('#devNameLabelBig').val() != "") {
            sendUpdateSensorName($('#devNameLabelBig').val());
        } else {
            showAlert('alert-error', '<b>Error!</b> Could not set empty device-name.');
            return;
        }
    }

    if (curDevice.type == "ZHASwitch") {
        updateRulesforBindings();
        setTimeout(function(){window.open("devices.html","_self")},200);
        return;
    }

    if ($('#selectTarget0').val() != "X" && $('#selectTarget1').val() != "X" && $('#selectTarget2').val() != "X" && $('#selectTarget3').val() != "X" && $('#selectTarget0').val() != null && $('#selectTarget1').val() != null && $('#selectTarget2').val() != null && $('#selectTarget3').val() != null && $('#selectTarget0').val() != undefined && $('#selectTarget1').val() != undefined && $('#selectTarget2').val() != undefined && $('#selectTarget3').val() != undefined) {
        // if button 1 has changed: update rule 1
        if (old.selectTarget0 != $('#selectTarget0').val() || old.selectFunction0 != $('#selectFunction0').val()) {
            ruleId = curRules[0].id;
            if (($('#selectFunction0').val() == 1) || ($('#selectFunction0').val() == 2)) {
                actionAddress = "/groups/0/action";
                actionBody = ($('#selectFunction0').val() == 1) ? "{\"on\":false}" : "{\"on\":true}";
            } else if (($('#selectFunction0').val() == 3) || ($('#selectFunction0').val() == 4)) {
                var groupId = $('#selectTarget0').val();
                actionAddress = "/groups/" + groupId + "/action";
                actionBody = ($('#selectFunction0').val() == 3) ? "{\"on\":false}" : "{\"on\":true}";
            } else if ($('#selectFunction0').val() == 5) {
                var groupId = ($('#selectTarget0').val()).substring(0,($('#selectTarget0').val()).indexOf('-'));
                var sceneId = ($('#selectTarget0').val()).substring(($('#selectTarget0').val()).indexOf('-')+1,($('#selectTarget0').val()).length);
                actionAddress = "/groups/" + groupId + "/scenes/" + sceneId + "/recall";
                actionBody = "{}";
            }
            sendUpdateRuleRest(ruleId, actionAddress, actionBody, "PUT");
        }
        // if button 2 has changed: update rule 2
        if (old.selectTarget1 != $('#selectTarget1').val() || old.selectFunction1 != $('#selectFunction1').val()) {
            ruleId = curRules[1].id;
            if (($('#selectFunction1').val() == 1) || ($('#selectFunction1').val() == 2)) {
                actionAddress = "/groups/0/action";
                actionBody = ($('#selectFunction1').val() == 1) ? "{\"on\":false}" : "{\"on\":true}";
            } else if (($('#selectFunction1').val() == 3) || ($('#selectFunction1').val() == 4)) {
                var groupId = $('#selectTarget1').val();
                actionAddress = "/groups/" + groupId + "/action";
                actionBody = ($('#selectFunction1').val() == 3) ? "{\"on\":false}" : "{\"on\":true}";
            } else if ($('#selectFunction1').val() == 5) {
                var groupId = ($('#selectTarget1').val()).substring(0,($('#selectTarget1').val()).indexOf('-'));
                var sceneId = ($('#selectTarget1').val()).substring(($('#selectTarget1').val()).indexOf('-')+1,($('#selectTarget1').val()).length);
                actionAddress = "/groups/" + groupId + "/scenes/" + sceneId + "/recall";
                actionBody = "{}";
            }
            sendUpdateRuleRest(ruleId, actionAddress, actionBody, "PUT");
        }
        // if button 3 has changed: update rule 3
        if (old.selectTarget2 != $('#selectTarget2').val() || old.selectFunction2 != $('#selectFunction2').val()) {
            ruleId = curRules[2].id;
            if (($('#selectFunction2').val() == 1) || ($('#selectFunction2').val() == 2)) {
                actionAddress = "/groups/0/action";
                actionBody = ($('#selectFunction2').val() == 1) ? "{\"on\":false}" : "{\"on\":true}";
            } else if (($('#selectFunction2').val() == 3) || ($('#selectFunction2').val() == 4)) {
                var groupId = $('#selectTarget2').val();
                actionAddress = "/groups/" + groupId + "/action";
                actionBody = ($('#selectFunction2').val() == 3) ? "{\"on\":false}" : "{\"on\":true}";
            } else if ($('#selectFunction2').val() == 5) {
                var groupId = ($('#selectTarget2').val()).substring(0,($('#selectTarget2').val()).indexOf('-'));
                var sceneId = ($('#selectTarget2').val()).substring(($('#selectTarget2').val()).indexOf('-')+1,($('#selectTarget2').val()).length);
                actionAddress = "/groups/" + groupId + "/scenes/" + sceneId + "/recall";
                actionBody = "{}";
            }
            sendUpdateRuleRest(ruleId, actionAddress, actionBody, "PUT");
        }
        // if button 4 has changed: update rule 4
        if (old.selectTarget3 != $('#selectTarget3').val() || old.selectFunction3 != $('#selectFunction3').val()) {
            ruleId = curRules[3].id;
            if (($('#selectFunction3').val() == 1) || ($('#selectFunction3').val() == 2)) {
                actionAddress = "/groups/0/action";
                actionBody = ($('#selectFunction3').val() == 1) ? "{\"on\":false}" : "{\"on\":true}";
            } else if (($('#selectFunction3').val() == 3) || ($('#selectFunction3').val() == 4)) {
                var groupId = $('#selectTarget3').val();
                actionAddress = "/groups/" + groupId + "/action";
                actionBody = ($('#selectFunction3').val() == 3) ? "{\"on\":false}" : "{\"on\":true}";
            } else if ($('#selectFunction3').val() == 5) {
                var groupId = ($('#selectTarget3').val()).substring(0,($('#selectTarget3').val()).indexOf('-'));
                var sceneId = ($('#selectTarget3').val()).substring(($('#selectTarget3').val()).indexOf('-')+1,($('#selectTarget3').val()).length);
                actionAddress = "/groups/" + groupId + "/scenes/" + sceneId + "/recall";
                actionBody = "{}";
            }
            sendUpdateRuleRest(ruleId, actionAddress, actionBody, "PUT");
        }
        setTimeout(function(){window.open("devices.html","_self")},200);
    } else {
        showAlert('alert-error', '<b>Error!</b> Could not set Scene or Group.');
    }
}

/**
 * update the rules for ZHASwitches that use bindings
 */
function updateRulesforBindings() {
    var sensorId = "";

    for (var i = 0; i < $(".lightOrGroup").length; i++) {
        var id = ($('#selectLightOrGroup'+i).val());

        if (curRules[i] != undefined) {

            if ($('#lightOrGroup'+i).val() == "3") {
                // only delete rule
                deleteSensorRule(curRules[i].id);
                continue;
            }

            //replace existing rule
            var ep = curRules[i].conditions[0].value;

            var addr = curRules[i].conditions[0].address;
            sensorId = (/\d+/.exec(addr.substring(9,addr.length)))[0];

            var bnd;
            for (property in curRules[i].actions[0].body) {
                bnd = (property == "on") ? "On/Off" : (property == "bri") ? "Dim" : "Scene";
            }

            if ($('#selectLightOrGroup'+i).val() != "X" &&
                $('#selectLightOrGroup'+i).val() != null &&
                $('#selectLightOrGroup'+i).val() != undefined) {

                if (($('#lightOrGroup'+i).val() == "1")) {
                    var actionAddress = "/lights/"+ id +"/state";
                } else {
                    var actionAddress = "/groups/"+ id +"/action";
                }
                var actionBody = JSON.stringify(curRules[i].actions[0].body);

                var rule = '{';
                rule += '"name":"Sensor: ' + sensorId + ' EP:'+ ep +' '+ bnd +'",';
                rule += '"status":"enabled",';
                rule += '"actions":[{"address":"'+ actionAddress +'","method":"BIND","body":'+ actionBody +'}],';
                rule += '"conditions":[{"address":"/sensors/' + sensorId + '/state/buttonevent","operator":"eq","value":"'+ ep +'"}]';
                rule += '}';

                if (actionAddress != curRules[i].actions[0].address) {
                    //sendUpdateRuleRest(curRules[i].id, actionAddress, actionBody, "BIND");
                    deleteSensorRule(curRules[i].id);
                    createRuleRest(rule);
                }
            }
        } else {
            //create new rule
            var ep = $('#'+i).attr("data-ep");
            sensorId = $('#'+i).attr("data-sid");
            var bnd = $('#bnd-'+i).text();

            if ($('#selectLightOrGroup'+i).val() != "X"
                && $('#selectLightOrGroup'+i).val() != null
                && $('#selectLightOrGroup'+i).val() != undefined)
                {
                    if (($('#lightOrGroup'+i).val() == "1")) {
                        var actionAddress = "/lights/"+ id +"/state";
                    } else {
                        var actionAddress = "/groups/"+ id +"/action";
                    }
                    var actionBody = (bnd === "On/Off") ? '{"on":true}' : (bnd === "Dim") ? '{"bri":1}' : '{"Scene":"1"}';

                    var rule = '{';
                    rule += '"name":"Sensor: ' + sensorId + ' EP:'+ ep +' '+ bnd +'",';
                    rule += '"status":"enabled",';
                    rule += '"actions":[{"address":"'+ actionAddress +'","method":"BIND","body":'+ actionBody +'}],';
                    rule += '"conditions":[{"address":"/sensors/' + sensorId + '/state/buttonevent","operator":"eq","value":"'+ ep +'"}]';
                    rule += '}';

                    createRuleRest(rule);
            }
        }
    }
}

/**
 * PUT /api/<apikey>/rules/<id>
 */
function sendUpdateRuleRest(ruleId, actionAddress, actionBody, method) {
    var action = '{"actions":[{';
    action += '"address":"' + actionAddress + '",';
    action += '"method":"'+ method +'",';
    action += '"body":' + actionBody + '}]}';

    $.ajax({
        url: '/api/' + apikey + '/rules/' +ruleId,
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: action,
        dataType: 'json',
        success: function(data) {
        },
        error: function(jqXHR, textStatus, errorThrown) {
            //showAlert('alert-error', '<b>Error!</b> Could not set button configuration.');
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

/**
 * POST /api/<apikey>/rules
 */
function createRuleRest(ruleData) {
    $.ajax({
        url: '/api/' + apikey + '/rules',
        type: 'POST',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: ruleData,
        dataType: 'json',
        success: function(data) {
        },
        error: function(jqXHR, textStatus, errorThrown) {
            //showAlert('alert-error', '<b>Error!</b> Could not set button configuration.');
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

/**
 * PUT /api/<apikey>/sensors/<id>
 */
function sendUpdateSensorName(name) {
    var sensorId = getURLParameter('device');
    $.ajax({
        url: '/api/' + apikey + '/sensors/' + sensorId,
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: '{"name":"' + name + '"}',
        dataType: 'json',
        success: function(data) {
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}


/**
 * PUT /api/<apikey>/Groups/<id>
 */
function sendRenameGroupRest(id, name) {
    $.ajax({
        url: '/api/' + apikey + '/groups/' + id,
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: '{"name":"' + name + '"}',
        dataType: 'json',
        success: function(data) {
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

/**
 * DELETE /api/<apikey>/sensors/<id>
 */
function deleteSensor() {
    var id;
    var epList = getURLParameter("ep").split(",");

    for (p in epList) {
        id = epList[p].substring(0,epList[p].indexOf("-"));

        sessionStorage.removeItem("reloadCount-" + id);

        $.ajax({
            url: '/api/' + apikey + '/sensors/' + id,
            type: 'DELETE',
            cache: false,
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success: function(data) {

            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log("textStatus:", textStatus + ' ' + errorThrown);
                console.log(jqXHR.responseText);
            },
            timeout: 10000
        });
    }
}

/**
 * DELETE /api/<apikey>/rules/<id>
 */
function deleteSensorRule(id) {
    $.ajax({
        url: '/api/' + apikey + '/rules/' + id,
        type: 'DELETE',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: '',
        success: function(data) {

        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

/**
 * DELETE /api/<apikey>/groups/<id>
 */
function deleteSensorGroup(id) {
    $.ajax({
        url: '/api/' + apikey + '/groups/' + id,
        type: 'DELETE',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success: function(data) {
            localStorage.removeItem("whitebarGroup-"+id);
            localStorage.removeItem("lightssequence-"+id);
            localStorage.removeItem("visible-"+id);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}


/**
 * Get all groups and scenes from configuration.
 */
function getFullConfiguration() {

    $.ajax({
        url: 'api/' + apikey,
        dataType: 'json',
        type: 'GET',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        success: function(json, status, xhr) {
            config = json;
            zigBeeChannel = config.config.zigbeechannel;

            for (lid in config.lights) {
                var light = config.lights[lid];
                allLights[allLights.length] = '<option value="'+ lid +'">'+ light.name +'</option>';
            }

            for (gid in config.groups) {
                var group = config.groups[gid];
                if (group.type !== 'LightGroup')
                    continue;

                allGroups[allGroups.length] = '<option value="'+ gid +'">'+ group.name +'</option>';

                for (sid in group.scenes) {
                    var scene = group.scenes[sid]
                    allScenes[allScenes.length] = '<option value="'+ gid + "-" + scene.id +'">'+ group.name +' - '+ scene.name + '</option>';
                }
            }
            // make available for caching
            if (Modernizr.sessionstorage) {
                sessionStorage.config = xhr.responseText;
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
                window.location.assign("/pwa/login.html");
                break;

            default:
                setTimeout(getFullConfiguration, 1000);
                //showAlert('alert-error', '<b>Error!</b> Lost connection, retry in one second ...');
                break;
            }
        },
        timeout: 10000
    });
}

/**
 * Helper Function to display Alerts
 */
function showAlert(alert, text, container) {
    if (typeof(container) === 'undefined') {
        container = '#alerts';
    }

    var d = new Date();
    var timestr = d.toUTCString();
    var txt = "";

    txt += '<div style="" class="alert ' + alert + '">';
    txt += text;
    txt += ' <span class="pull-right hidden-phone">';
    txt += '</span></div>';

    setTimeout(function() {
        $(container).html(txt).scrollintoview();
    }, 250);
}

$(document).on('keydown', '.navbar-form #devNameLabelBig', function(event) {
    if(event.keyCode == 13) {
        if (event.target.nodeName === "INPUT") {
            isFocused = false;
            event.target.blur();
            event.preventDefault();
            return false;
        }
    }
});

/**
 * Select list click handler for tap
 */
$(document).on('change', '.selectFunction', function(e) {
    var i = e.target.parentNode.parentNode.id;
    if ((e.target.value == "1") || (e.target.value == "2")) {
        $('#selectTarget'+i).html('<option value="0">&#10003;</option>');
    } else if ((e.target.value == "3") || (e.target.value == "4")) {
        $('#selectTarget'+i).html("");
        if (allGroups.length === 0) {
            $('#selectTarget'+i).append("<option value=\"X\">No Group found</option>");
        } else {
            for (option in allGroups) {
                $('#selectTarget'+i).append(allGroups[option]);
            }
        }
    } else if (e.target.value == "5") {
        $('#selectTarget'+i).html("");
        if (allScenes.length === 0) {
            $('#selectTarget'+i).append("<option value=\"X\">No Scene found</option>");
        } else {
            for (option in allScenes) {
                $('#selectTarget'+i).append(allScenes[option]);
            }
        }
    }
});

/**
 * Select list click handler for switch
 */
$(document).on('change', '.lightOrGroup', function(e) {
    var i = e.target.parentNode.parentNode.id;
    if (e.target.value == "1") {
        $('#selectLightOrGroup'+i).html("");
        if (allLights.length === 0) {
            $('#selectLightOrGroup'+i).append("<option value=\"X\">No Lights found</option>");
        } else {
            for (option in allLights) {
                $('#selectLightOrGroup'+i).append(allLights[option]);
            }
        }
    } else if (e.target.value == "2"){
        $('#selectLightOrGroup'+i).html("");
        if (allGroups.length === 0) {
            $('#selectLightOrGroup'+i).append("<option value=\"X\">No Groups found</option>");
        } else {
            for (option in allGroups) {
                $('#selectLightOrGroup'+i).append(allGroups[option]);
            }
        }
    } else if (e.target.value == "3"){
        $('#selectLightOrGroup'+i).html("<option>Delete this Rule</option>");
    }
});

$(document).on('click', '#changeMode-btn', function(e) {
    $('#changeModeModal').modal('show');
    if (lightingSwitchMode == "1") {
        $('#curMode').html('<b>Scenes Mode</b>');
        $('#modeBtn1').text('Two Groups');
        $('#modeBtn1').attr('data-mode','2');
        $('#modeBtn2').text('Color Temperature');
        $('#modeBtn2').attr('data-mode','3');
        $('#modeDescr1').text('The left and the right switch-button control two different groups.');
        $('#modeDescr2').text('The right switch-button controls the color temperature.');
    } else if (lightingSwitchMode == "2") {
        $('#curMode').html('<b>Two Groups</b>');
        $('#modeBtn1').text('Scenes Mode');
        $('#modeBtn1').attr('data-mode','1');
        $('#modeBtn2').text('Color Temperature');
        $('#modeBtn2').attr('data-mode','3');
        $('#modeDescr1').text('You can save 2 scenes on the right switch-button.');
        $('#modeDescr2').text('The right switch-button controls the color temperature.');
    } else if (lightingSwitchMode == "3") {
        $('#curMode').html('<b>Color Temperature</b>');
        $('#modeBtn1').text('Two Groups');
        $('#modeBtn1').attr('data-mode','2');
        $('#modeBtn2').text('Scenes Mode');
        $('#modeBtn2').attr('data-mode','1');
        $('#modeDescr1').text('The left and the right switch-button control two different groups.');
        $('#modeDescr2').text('You can save 2 scenes on the right switch-button.');
    }
});

$(document).on('click', '.modeBtn', function(e) {
    var html = '';
    var pic = "";
    if (curDevice.mode == 1) {
        pic = "img/lighting_switch_scenes_mode.png";
    } else if (curDevice.mode == 2) {
        pic = "img/lighting_switch_groups_mode.png";
    } else if (curDevice.mode == 3) {
        pic = "img/lighting_switch_ct_mode.png";
    }
    html += '<b>2. Enter the configuration mode of the switch.</b>';
    html += '<ul><li>Press the top left and the bottom right corners on the switch for 4 seconds.</li>';
    html += '<li>The red LED on the switch starts to blink slowly.</li></ul>';
    html += '<p><img style="margin-left:20px;" src="'+ pic +'" /></p>'
    html += '<ul><li><b>Click Next</b></li></ul>';
    $('#switchModeText').html(html);
    if ($(this).attr('data-mode') == '1') {
        $('#btn-scenes-mode-next').removeClass('hidden');
    } else if ($(this).attr('data-mode') == '2') {
        $('#btn-groups-mode-next').removeClass('hidden');
    } else if ($(this).attr('data-mode') == '3') {
        $('#btn-ct-mode-next').removeClass('hidden');
    }
});

function changeScenesModeNext() {
    var html = '';
    if ($('#btn-scenes-mode-next').attr('data-step') == "1") {
        html += '<b>3. Change the mode to Scenes mode</b>';
        html += '<ul><li>Press the top left and right corner of the switch briefly until the top green LED is lighting.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_change_scenes_mode.png" /></p>'
        html += '<ul><li><b>Click Next</b></li></ul>';
        $('#cancelBtn').addClass('hidden');
        $('#btn-scenes-mode-next').attr('data-step','2')
    } else if ($('#btn-scenes-mode-next').attr('data-step') == "2") {
        html += '<b>4. Leave the configuration mode.</b>';
        html += '<li>Press the top left and the bottom right button on the switch for 4 seconds to leave the config mode.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_scenes_mode.png" /></p>'
        html += '<ul><li>The green and red LEDs on the switch stop lighting.</li>';
        html += '<li><b>Click Finish</b></li></ul>';
        $('#btn-scenes-mode-next').addClass('hidden');
        $('#cancelBtn').removeClass('hidden');
        $('#cancelBtn').html('Finish');
        $('#cancelBtn').addClass('btn-primary');

        var gid1 = $('.groupNameLabel:eq(1)').attr("id");
        saveSwitchMode(1);
        saveGroupHiddenStatus(gid1,true);
    }
    $('#switchModeText').html(html);
}

function changeCtModeNext() {
    var html = '';
    if ($('#btn-ct-mode-next').attr('data-step') == "1") {
        html += '<b>3. Change the mode to Color Temperature</b>';
        html += '<ul><li>Press the top left and right corner of the switch briefly until both green LEDs are lighting.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_change_ct_mode.png" /></p>'
        html += '<ul><li><b>Click Next</b></li></ul>';
        $('#cancelBtn').addClass('hidden');
        $('#btn-ct-mode-next').attr('data-step','2')
    } else if ($('#btn-ct-mode-next').attr('data-step') == "2") {
        html += '<b>4. Leave the configuration mode.</b>';
        html += '<li>Press the top left and the bottom right button on the switch for 4 seconds to leave the config mode.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_ct_mode.png" /></p>'
        html += '<ul><li>The green and red LEDs on the switch stop lighting.</li>';
        html += '<li><b>Click Finish</b></li></ul>';
        $('#btn-ct-mode-next').addClass('hidden');
        $('#cancelBtn').removeClass('hidden');
        $('#cancelBtn').html('Finish');
        $('#cancelBtn').addClass('btn-primary');

        var gid = $('.groupNameLabel:eq(1)').attr("id");
        saveSwitchMode(3);
        saveGroupHiddenStatus(gid,true);
    }
    $('#switchModeText').html(html);
}

function changeGroupsModeNext() {
    var html = '';
    if ($('#btn-groups-mode-next').attr('data-step') == "1") {
        html += '<b>3. Change the mode to Two Groups</b>';
        html += '<ul><li>Press the top left and right corner of the switch briefly until the bottom green LED is lighting.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_change_groups_mode.png" /></p>'
        html += '<ul><li><b>Click Next</b></li></ul>';
        $('#cancelBtn').addClass('hidden');
        $('#btn-groups-mode-next').attr('data-step','2')
    } else if ($('#btn-groups-mode-next').attr('data-step') == "2") {
        html += '<b>4. Leave the configuration mode.</b>';
        html += '<li>Press the top left and the bottom right button on the switch for 4 seconds to leave the config mode.</li></ul>';
        html += '<p><img style="margin-left:20px;" src="img/lighting_switch_groups_mode.png" /></p>'
        html += '<ul><li>The green and red LEDs on the switch stop lighting.</li>';
        html += '<li><b>Click Finish</b></li></ul>';
        $('#btn-groups-mode-next').addClass('hidden');
        $('#cancelBtn').removeClass('hidden');
        $('#cancelBtn').html('Finish');
        $('#cancelBtn').addClass('btn-primary');

        //var gid = $('.groupNameLabel:eq(1)').attr("id");
        saveSwitchMode(2);

        var idEp = getURLParameter("ep");
        var epList = idEp.split(",");
        for (e in epList) {
            var id = epList[e].substring(0,epList[e].indexOf("-"));
            for (g in config.groups) {
                if (config.groups[g].devicemembership[0] == id) {
                    saveGroupHiddenStatus(g,false);
                    break;
                }
            }
        }
    }
    $('#switchModeText').html(html);
}

function saveSwitchMode(mode) {
    var id = getURLParameter("device");
   $.ajax({
        url: '/api/' + apikey + '/sensors/' + id,
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: '{"mode":' + mode + '}',
        dataType: 'json',
        success: function(data) {
            console.log("change mode successful");
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

function saveGroupHiddenStatus(gid, hidden) {
   $.ajax({
        url: '/api/' + apikey + '/groups/' + gid,
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        data: '{"hidden":' + hidden + '}',
        dataType: 'json',
        success: function(data) {
            console.log("group" + gid + "hidden: " + hidden);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("textStatus:", textStatus + ' ' + errorThrown);
            console.log(jqXHR.responseText);
        },
        timeout: 10000
    });
}

$('#changeModeModal').on('hidden', function () {
        location.reload(true);
})

/**
 * Start search for new sensors.
 */
function findNewSensors() {
    $.ajax({
        url: 'api/' + apikey + '/sensors',
        dataType: 'json',
        type: 'POST',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        //data: JSON.stringify(params),
        success: function(json) {
            // TODO extract duration
            console.log("start search for new sensors.");
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("start search for new sensors failed.");
        }
    });
}

/**
 * Open the network for a given period.
 */
function openNetwork(seconds) {

    var params = { "permitjoin" : parseFloat(seconds) };

    $.ajax({
        url: 'api/' + apikey + '/config',
        dataType: 'json',
        type: 'PUT',
        cache: false,
        contentType: 'application/json; charset=utf-8',
        headers: { 'Accept': apiversion },
        data: JSON.stringify(params),
        success: function(json) {
            console.log("open network for " + seconds + " seconds.");
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("open network failed.");
        }
    });
}

