
function addScene() {
	var ul = document.querySelector('#pageSceneEdit .sceneList');

	var group = curEdit.obj;
	var txt = "";
	var sid = 1;

	// create new scene id
	for (var i = 0; i < group.scenes.length; i++) {
		var scene = group.scenes[i];
		var cmp = parseInt(scene.id, 16);
		if (cmp >= sid) { // take maximum
			sid = cmp + 1;
		}
	}

	sid = "0x" + sid.toString(16);
	var scene = { "id": sid, "name": "scene " + sid };

	group.scenes.push(scene);
	
	txt += '<li>'
	txt += '<input name="' + scene.name + '" value="" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">';
	txt += '<span class="actionButton storeButton" data-action="storeScene" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">store</span>';
	txt += '<span class="actionButton removeButton" data-action="removeScene" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">&times;</span>';
	txt += '</li>';

	ul.innerHTML += txt;

	// force creation of scene on devices
	storeScene(group.rgid, sid);

	$('input[data-sid="' + scene.id + '"]', ul).focus();
};

function storeScene(rgid, sid) {
	var out = { };

	out.id = rgid;
	out.rgid = rgid;
	out.sid = sid;
	out.type = TYPE_SCENE;
    out.action = ACTION_STORE_SCENE;

	pushObjState(out);
};

function removeScene(rgid, sid) {
	var out = { };

	out.id = rgid;
	out.rgid = rgid;
	out.sid = sid;
	out.type = TYPE_SCENE;
    out.action = ACTION_REMOVE_SCENE;

	pushObjState(out);
};

function setSceneName(input) {
	var group = curEdit.obj;
	var sid = input.dataset.sid;

	for (var i = 0; i  < group.scenes.length; i++) {
		var scene = group.scenes[i];
		if (scene.id === sid) {
			if (scene.name === input.value) {
				return; // nothing todo
			}

			scene.name = input.value;

			if (scene.name == "") {
				scene.name = scene.id;
				input.value = scene.name;
			}

			var out = { };

			out.id = group.rgid;
			out.rgid = group.rgid;
			out.sid = sid;
			out.type = TYPE_SCENE;
		    out.action = ACTION_SET_NAME;
		    out.name = scene.name;

			pushObjState(out);

			updateGroupUi(group);

			break;
		}
	}

};

function onSceneEditClick(e) {
    if (e.target.nodeName == "INPUT") {
        if (curInput !== undefined) {
            curInput.blur();
        }
    	curInput = e.target;
        curInput.focus();
        return;
    }

    if (curInput !== undefined) {
        curInput.blur();
        curInput = undefined;
    }

	var action = e.target.dataset.action;

	if (action !== undefined) {

		if (action === "close") {
			hideSceneEditPage();
			showLightListPage();
		}
		else if (action === "storeScene") {
			var rgid = e.target.dataset.rgid;
			var sid = e.target.dataset.sid;
			storeScene(rgid, sid);
		}
		else if (action === "removeScene") {
			var rgid = e.target.dataset.rgid;
			var sid = e.target.dataset.sid;
			removeScene(rgid, sid);
		}
		else if (action === "add") {
			addScene();
		}
	}
};

// Desktop and Android enter key
function onSceneEditKeyup(e) {
	    if (e.keyCode === 13) { // enter
	    	if (e.target.nodeName === "INPUT") {
				setSceneName(e.target);
				e.target.blur();
			}
	    }
};

// Support iOS virtual keyboard "done" button
function onSceneEditBlur(e) {
	if (e.target.nodeName === "INPUT") {
		setSceneName(e.target);
	}
};

function showSceneEditPage() {
	$(pageSceneEdit).removeClass("pageHide");

	var ul = document.querySelector('#pageSceneEdit .sceneList');

	var group = curEdit.obj;
	var txt = "";

	for (var i = 0; i < group.scenes.length; i++) {
		var scene = group.scenes[i];

		txt += '<li>'
		txt += '<input name="' + scene.name + '" value="' + scene.name + '" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">';
		txt += '<span class="actionButton storeButton" data-action="storeScene" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">store</span>';
		txt += '<span class="actionButton removeButton" data-action="removeScene" data-rgid="' + group.rgid + '" data-sid="' + scene.id + '">&times;</span>';
		txt += '</li>';
	}

	ul.innerHTML = txt;



	document.addEventListener(clickevent, onSceneEditClick, false);
	document.addEventListener("blur", onSceneEditBlur, true);
    document.addEventListener("keyup", onSceneEditKeyup, true);


};

function hideSceneEditPage() {
	document.removeEventListener(clickevent, onSceneEditClick, false);
	document.removeEventListener("blur", onSceneEditBlur, true);
	document.removeEventListener("keyup", onSceneEditKeyup, true);

	$(pageSceneEdit).addClass("pageHide");
};