/*! phoscon-app 2025-08-29 */

export const SW_CLASSID_MIN=3001;export const SW_CLASSID_MAX=3024;export const CLASSIDON=3001;export const CLASSIDOFF=3002;export const CLASSIDTOGGLEONOFF=3003;export const CLASSIDNEXTSCENE=3004;export const CLASSIDPREVSCENE=3005;export const CLASSIDCALLSCENE=3006;export const CLASSIDBRIUP=3007;export const CLASSIDBRIDOWN=3008;export const CLASSIDPUSHDIM=3009;export const CLASSIDPUSHDIMUP=3010;export const CLASSIDPUSHDIMDOWN=3011;export const CLASSIDBRIDIMUP=3012;export const CLASSIDBRIDIMDOWN=3013;export const CLASSIDCOLORLOOPSTART=3014;export const CLASSIDCOLORLOOPSTOP=3015;export const CLASSIDCOLORLOOPTOGGLE=3016;export const CLASSIDCTUP=3017;export const CLASSIDCTDOWN=3018;export const CLASSIDDIMCT=3019;export const CLASSIDDIMCTUP=3020;export const CLASSIDDIMCTDOWN=3021;export const CLASSIDCALLEFFECT=3022;export const CLASSIDNEXTEFFECT=3023;export const CLASSIDALLOFF=3024;export const devicehasLongPressMap={Philips:[{modelid:"RWL020",buttons:["100","200","300","400"]},{modelid:"RWL021",buttons:["100","200","300","400"]},{modelid:"ROM001",buttons:["100"]},{modelid:"RDM003",buttons:["100"]}],PhilipsFoH:[{modelid:"FOHSWITCH",buttons:["100","200","300","400","500","600"]}],Insta:[{modelid:"WS_3f_G_1",buttons:["100","200"]},{modelid:"HS_4f_GJ_1",buttons:["100","200"]},{modelid:"WS_4f_J_1",buttons:["100","200"]}],"dresden elektronik":[{modelid:"Scene Switch",buttons:["100","200"]},{modelid:"Lighting Switch",buttons:["100","200","300","400"]}],"IKEA of Sweden":[{modelid:"TRADFRI remote control",buttons:["200","300","400","500"]},{modelid:"TRADFRI on/off switch",buttons:["100","200"]},{modelid:"TRADFRI SHORTCUT Button",buttons:["100"]},{modelid:"Remote Control N2",buttons:["100","200","300","400"]}],LUMI:[{modelid:"lumi.sensor_switch.aq3",buttons:["100"]},{modelid:"lumi.sensor_switch",buttons:["100"]},{modelid:"lumi.remote.b1acn01",buttons:["100"]},{modelid:"lumi.remote.b286opcn01",buttons:["100","200"],buttonExtra:["002","004","005"]},{modelid:"lumi.remote.b486opcn01",buttons:["100","200","300","400"],buttonExtra:["002","004","005"]},{modelid:"lumi.remote.b686opcn01",buttons:["100","200","300","400","500","600"],buttonExtra:["002","004","005"]}],"Busch-Jaeger":[{modelid:"RB01",buttons:["100","200","300","400","500","600","700","800"]},{modelid:"RM01",buttons:["100","200","300","400","500","600","700","800"]}],icasa:[{modelid:"ICZB-KPD12",buttons:["100","200"]},{modelid:"ICZB-KPD14S",buttons:["100","200"]},{modelid:"ICZB-KPD18S",buttons:["100","200"]}],OSRAM:[{modelid:"Switch-LIGHTIFY",buttons:["100","200","300","400"]},{modelid:"Switch 4x EU-LIGHTIFY",buttons:["100","200","300","400"]},{modelid:"Switch 4x-LIGHTIFY",buttons:["100","200","300","400"]},{modelid:"Lightify Switch Mini",buttons:["100","200","300"]}],Legrand:[{modelid:"Double gangs remote switch",buttons:["100","200","300","400"]}],"Signify Netherlands B.V.":[{modelid:"RDM001 singlepushbutton",buttons:["100"]},{modelid:"RDM001 dualpushbutton",buttons:["100","200"]},{modelid:"RDM004 singlepushbutton",buttons:["100"]},{modelid:"RDM004 dualpushbutton",buttons:["100","200"]},{modelid:"RWL022",buttons:["100","200","300","400"]},{modelid:"RDM002",buttons:["100","200","300","400"]}]};export const rlFunctionMap=[{options:[3001,3002,3003,3024],translateId:"func_onOffOptions",iconId:"#power-options-icon",templ:"onOffOptions-item-template",class:"onoff-options"},{options:[3006,3004,3005],translateId:"func_callScene",iconId:"#scenes-icon",templ:"callScene-item-template",class:"callscene-options"},{options:[3007,3008],translateId:"func_dimming",iconId:"#sun-icon",templ:"dimm-item-template",class:"dimm-options"},{options:[3009,3010,3011],translateId:"func_dimming",iconId:"#sun-icon",templ:"pushdimm-item-template",class:"pushdimm-options"},{options:[3016],translateId:"func_effect",iconId:"#effect-icon",templ:"effect-item-template",class:"effect-options"},{options:[3022,3023],translateId:"func_effect_lightChain",iconId:"#effect-icon",templ:"lightChain-item-template",class:"lightChain-options"},{options:[3017,3018],translateId:"func_colorTemp",iconId:"#temperature-icon",templ:"ct-item-template",class:"ct-options"},{options:[3019,3020,3021],translateId:"func_colorTemp",iconId:"#temperature-icon",templ:"ct-push-item-template",class:"ct-push-options"},{translateId:"basic_functions",iconId:"#empty-frame-icon",templ:"group-mode-item-template",class:"group-mode"}];export const classIdFunctionMap={3001:"on",3002:"off",3003:"toggleOnOff",3024:"allOff",3006:"callScene",3004:"nextScene",3005:"prevScene",3007:"briUp",3008:"briDown",3012:"briDimUp",3013:"briDimDown",3009:"pushDim",3010:"pushDimUp",3011:"pushDimDown",3016:"toggleColorLoop",3022:"callEffect",3023:"nextEffect",3017:"ctUp",3018:"ctDown",3019:"dimCt",3020:"dimCtUp",3021:"dimCtDown"};export const Events={SW_PRESSED:"SW_PRESSED",RL_PRESSED:"RL_PRESSED",FUNC_PRESSED:"FUNC_PRESSED",BTN_ADD_SWITCH_PRESSED:"BTN_ADD_SWITCH_PRESSED",BTN_ADD_RL_PRESSED:"BTN_ADD_RL_PRESSED",BTN_CLOSE_PRESSED:"BTN_CLOSE_PRESSED",BTN_NEXT_PRESSED:"BTN_NEXT_PRESSED",BTN_PREV_PRESSED:"BTN_PREV_PRESSED",SW_MODAL_PRESSED:"SW_MODAL_PRESSED",SW_TARGET_PRESSED:"SW_TARGET_PRESSED",FUNC_MODAL_PRESSED:"FUNC_MODAL_PRESSED",SUBFUNC_MODAL_PRESSED:"SUBFUNC_MODAL_PRESSED",BTN_GROUPMODE_PRESSED:"BTN_GROUPMODE_PRESSED",BTN_EDITORMODE_PRESSED:"BTN_EDITORMODE_PRESSED"};export const States={OVERVIEW:"OVERVIEW",ACTIVESW:"ACTIVESW",ACTIVERL:"ACTIVERL",ACTIVEFUNC:"ACTIVEFUNC",PAGE_SWITCHES:"PAGE_SWITCHES",PAGE_BUTTONS:"PAGE_BUTTONS",PAGE_FUNCTIONS:"PAGE_FUNCTIONS",PAGE_GROUPMODE:"PAGE_GROUPMODE",PAGE_GROUPMODEINFO:"PAGE_GROUPMODEINFO"};export const createResource=(gid,snid,oid,eid,color,activeResource,c,view,statekey,addoid)=>new Promise((resolve,reject)=>{if(!(gid&&snid&&oid&&c))return reject("missing parameter, function createResource");var ruleMap,ruleMapParam={c:c,gid:gid||0,snid:snid||0,lid:0,sid:0,btnEv:[0,0,0],ctPercent:0,briPercent:0,satPercent:0,loopspeed:0,lightEffect:eid||getEid(activeResource),statekey:statekey||"buttonevent",color:color},hf=c.helperFuncs,sw=app.switches.get(app.session.swid);if(0!==eid){let light=app.groups.get(gid).get("lights").map(lid=>app.lights.get(lid)).find(light=>"HG06467"===light.get("modelid"));light&&(ruleMapParam.lid=light.get("id"))}if(oid==classIdFunctionMap[3007]||oid==classIdFunctionMap[3008]){const briLevel=view.getSelectValue("#selBri")||5,briPercent=Math.round(2.54*briLevel);ruleMapParam.briPercent=briPercent}else if(oid==classIdFunctionMap[3017]||oid==classIdFunctionMap[3018]){const ctLevel=view.getSelectValue("#selCt")||5,ctPercent=Math.round(3.47*ctLevel);ruleMapParam.ctPercent=ctPercent}else if(oid==classIdFunctionMap[3022]){let color=view.getSelectValue("#selColor");ruleMapParam.color=color}else if(oid==classIdFunctionMap[3006]){let sid=view.getSelectValue("#sceneList");ruleMapParam.sid=sid}var classId=getKeyByValue(classIdFunctionMap,oid),swBtnEv=activeResource?getSwButton(activeResource):app.session.dataBtn.split(",");ruleMapParam.btnEv=swBtnEv;var genericSensor,subRuleList,ruleList=(ruleMap=c.createRuleMap(ruleMapParam))[parseInt(classId)]||[],resourceLinkName=classIdFunctionMap[classId],rules=[],subRules=[];if(addoid){let subClassid=getKeyByValue(classIdFunctionMap,addoid);subRuleList=ruleMap[parseInt(subClassid)]||[],[genericSensor,subRules]=getRulesFromList(subRuleList)}if([genericSensor,rules]=getRulesFromList(ruleList),0==rules.length)return reject("missing rules in function createRule");var p=[];const rs={classid:parseInt(classId),description:"Resourcelink for switch rule",name:"opt_"+resourceLinkName,links:["/groups/"+gid,"/sensors/"+snid]};if(ruleMapParam.sid&&rs.links.push("/scenes/"+ruleMapParam.sid),ruleMapParam.lightEffect&&rs.links.push("/effect/"+ruleMapParam.lightEffect),genericSensor)restCreateResource(app.sensors,genericSensor).then(id=>{var gsnid=id;rs.links.push("/sensors/"+id),gsnid?(rules.forEach(rule=>{rule=replaceGsnid(rule,gsnid),p.push(restCreateResource(app.rules,rule))}),Promise.all(p).then(result=>{result.forEach(rid=>rs.links.push("/rules/"+rid)),restCreateResource(app.resourcelinks,rs).then(rlid=>{activeResource&&hf.deleteResource(activeResource,sw),resolve(rlid)}).catch(reject)}).catch(console.log)):reject(new Error("gsnid is missing"))});else if(0!==subRules.length){let subClassid=getKeyByValue(classIdFunctionMap,addoid),rlName=classIdFunctionMap[subClassid];getSubResource({classid:parseInt(subClassid),description:"Resourcelink for switch rule",name:"opt_"+rlName,links:["/groups/"+gid,"/sensors/"+snid]},subRules).then(rlid=>{rs.links.push("/resourcelinks/"+rlid),rules.forEach(rule=>p.push(restCreateResource(app.rules,rule))),Promise.all(p).then(result=>{result.forEach(rid=>rs.links.push("/rules/"+rid)),restCreateResource(app.resourcelinks,rs).then(rlid=>{activeResource&&hf.deleteResource(activeResource,sw),resolve(rlid)}).catch(reject)})})}else rules.forEach(rule=>p.push(restCreateResource(app.rules,rule))),Promise.all(p).then(result=>{result.forEach(rid=>rs.links.push("/rules/"+rid)),restCreateResource(app.resourcelinks,rs).then(rlid=>{activeResource&&hf.deleteResource(activeResource,sw),resolve(rlid)}).catch(reject)})});function getSubResource(rsSub,subRules){return new Promise((resolve,reject)=>{var subP=[];subRules.forEach(rule=>subP.push(restCreateResource(app.rules,rule))),Promise.all(subP).then(result=>{result.forEach(rid=>rsSub.links.push("/rules/"+rid)),restCreateResource(app.resourcelinks,rsSub).then(rlid=>{resolve(rlid)}).catch(error=>{reject(error)})})})}function getEid(rl){if(!rl)return 0;let effectString=rl.get("links").find(l=>-1!=l.indexOf("/effect/"));return effectString&&effectString.split("/")[2]||0}function getRulesFromList(ruleList){let genericSensor,rules=[];return ruleList.forEach(item=>{if(-1===item.name.indexOf("CLIP")){var rule={name:item.name,conditions:[],actions:[]};item.conditions.forEach(c=>{let con={address:c.address,operator:c.operator};c.value&&(con.value=c.value),rule.conditions.push(con)}),item.actions.forEach(a=>{let act={address:a.address,body:a.body,method:a.method};rule.actions.push(act)}),rules.push(rule)}else genericSensor=item}),[genericSensor,rules]}function replaceGsnid(rule,gsnid){let r={};return r.name=rule.name,r.actions=[],r.conditions=[],rule.actions.forEach(a=>{a.address=a.address.replace("{gsnid}",gsnid),r.actions.push(a)}),rule.conditions.forEach(c=>{c.address=c.address.replace("{gsnid}",gsnid),r.conditions.push(c)}),r}function getKeyByValue(object,value){return Object.keys(object).find(key=>object[key]===value)}export function getRlDataMap(rl){return rlFunctionMap.find(rlF=>-1!=rlF.options.indexOf(rl.get("classid")))||void 0};function getSwButton(rl){return rl.get("links").filter(l=>-1!==l.indexOf("rules")).map(r=>r.split("/")[2]).map(rid=>app.rules.get(rid)).map(r=>r.get("conditions").find(c=>-1!==c.address.indexOf("buttonevent")||-1!==c.address.indexOf("gesture"))).map(v=>v.value)}export function getSwitchesWithRules(){let result=[];return app.resourcelinks.filter(r=>r.get("classid")>SW_CLASSID_MIN||r.get("classid")<SW_CLASSID_MAX).forEach(rl=>{let links=rl.get("links"),group=links.find(l=>-1!==l.indexOf("group"));group&&group.split("/")[2]!=app.session.gid||(result=links.filter(l=>-1!==l.indexOf("sensors")).map(s=>s.split("/")[2]))}),result};