<!-- template for switch details -->
<script type="text/us-templ" id="blind-details-template">
    <div class="main-head">
        <h1>
            <img src="img/blinds/48px/blind-icon.svg#generic-blind-icon" data-svgInject="switchWizzardSvg" data-wiz-page="none" class="svg-icon mq-desktop"/>
            <span><%- attributes.name %></span>
            <div class="item-edit pencil mq-desktop" data-toggle="modal" data-target="#renameBlindModal" data-swid="<%- cid %>">
                <svg width="24" height="24"><use transform="scale(0.48)" xlink:href="#icon-rename" /></svg>
            </div>
            <div class="mq-phone context-menu-box">
            <div class="context-menu-outer"></div>
                <svg class="context-menu-icon" width="24" height="24"><use transform="scale(0.48)" xlink:href="#dot-menu" /></svg>
                <ul class="context-menu">
                    <li data-toggle="modal" data-target="#renameBlindModal" data-swid="<%- cid %>">
                        <svg width="18" height="18"><use transform="scale(0.36)" xlink:href="#icon-rename" /></svg>
                        <span data-translateid="txt_rename">Umbenennen</span>
                    </li>
                    <li data-toggle="modal" data-target="#deleteBlindModal">
                        <!-- templ-include: img/24px/delete.svg -->
                        <span data-translateid="txt_delete">Löschen</span>
                    </li>
                </ul>
            </div>
        </h1>
        <a id="deleteSwitches_btn" type="button" class="hdr-delete-btn mq-desktop" data-toggle="modal" data-target="#deleteBlindModal">
            <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#delete-icon-sm" /></svg>
            <span data-translateid="text_delete_blind"></span>
        </a>
    </div>

    <div class="main-content">
        <span class="range-slider">
            <span class="slider-container"></span>
            <span class="bar"></span>
            <div class="touch-info">
                <span class="touch-infotext">100%</span>
            </div>
        </span>

        <div id="detailInfos">
            <div class="generals">
                <span data-translateid="th_vendor">Vendor</span> 
                <span class="vendor"><%- attributes.manufacturername %></span>

                <span data-translateid="th_product">Product</span> 
                <span class="product"><%- attributes.product %></span>
            </div>

            <div class="swversion">
                <span data-translateid="th_version">Version</span> 
                <span><%- attributes.swversion %></span>
            </div>

            <div class="state" style="display: grid;">
                <span class="bri" data-translateid="th_state"></span> 
                <span class="bri"><%- attributes.state.lift %>%</span>
                
                <span class="battery" data-translateid="th_battery"></span> 
                <span class="battery"><%- attributes.state.battery %>%</span>
            </div>
        </div>
    </div>
</script>